package ru.yandex.market.logshatter.parser.trace;

import java.util.Date;
import java.util.Optional;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 13/09/16
 */
public class RequestId {
    private final long idMillis;
    private final String idHash;
    private final Integer[] idSeq;

    private RequestId(long idMillis, String idHash, Integer[] idSeq) {
        this.idMillis = idMillis;
        this.idHash = idHash;
        this.idSeq = idSeq;
    }

    public static boolean validate(String requestId) {
        if (requestId.isEmpty()) {
            return false;
        }
        if (requestId.indexOf('/') < 0) {
            return false;
        }
        return true;
    }

    public static Optional<RequestId> parseOptional(String requestId) {
        if (!RequestId.validate(requestId)) {
            return Optional.empty();
        }
        return Optional.of(parse(requestId));
    }

    public static RequestId parse(String requestId) {
        String[] requestIdParts = requestId.split("/");
        long idMillis = Long.parseUnsignedLong(requestIdParts[0]);

        String idHash = requestIdParts[1];

        Integer[] idSubrequests = parseSubrequestIds(requestIdParts);
        return new RequestId(idMillis, idHash, idSubrequests);
    }


    private static Integer[] parseSubrequestIds(String[] requestIdParts) {
        Integer[] subrequestIds = new Integer[requestIdParts.length - 2];

        for (int i = 2; i < requestIdParts.length; i++) {
            subrequestIds[i - 2] = Integer.parseUnsignedInt(requestIdParts[i]);
        }

        return subrequestIds;
    }

    public long getIdMillis() {
        return idMillis;
    }

    public String getIdHash() {
        return idHash;
    }

    public Integer[] getIdSeq() {
        return idSeq;
    }

    public Date getDate() {
        return new Date(idMillis);
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder(Long.toUnsignedString(idMillis) + '/' + idHash);
        for (Integer num : idSeq) {
            text.append('/').append(Integer.toUnsignedString(num));
        }
        return text.toString();
    }
}
