package ru.yandex.market.logshatter.parser.trace;

import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;

/**
 * @author Anton Sukhonosenko <a href="mailto:algebraic@yandex-team.ru"></a>
 * @date 19.08.16
 */
public class TraceLogParser extends AbstractTraceLogParser {

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        Environment environment = getEnvironment(context);
        TraceLogEntry entry = new TraceLogEntry(line, context);

        context.write(
            entry.getRequestId().getDate(),
            entry.getRequestId().getIdMillis(),
            entry.getRequestId().getIdHash(),
            entry.getRequestId().getIdSeq(),
            entry.getStartTimeMs(),
            entry.getEndTimeMs(),
            entry.getDurationMs(),
            entry.getRequestType(),
            entry.getModule(),
            context.getHost(),
            entry.getSourceModule(),
            entry.getSourceHost(),
            entry.getTargetModule(),
            entry.getTargetHost(),
            environment,
            entry.getRequestMethod(),
            entry.getHttpCode(),
            entry.getRetryNum(),
            entry.getErrorCode(),
            entry.getProtocol(),
            entry.getHttpMethod(),
            entry.getQueryParams(),
            entry.getYandexUid(),
            entry.getYandexLogin(),
            entry.getKvKeys().toArray(),
            entry.getKvValues().toArray(),
            entry.getEvents().toArray(),
            entry.getEventTimestamps().toArray(),
            entry.getTestIds(),
            entry.getPage().getId(),
            entry.getPage().getType(),
            entry.getResponseSizeBytes()
        );
    }

}
