package ru.yandex.market.logshatter.reader;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.market.logshatter.LogShatterMonitoring;
import ru.yandex.market.logshatter.LogShatterService;
import ru.yandex.market.logshatter.config.ConfigurationService;
import ru.yandex.market.logshatter.logging.BatchErrorLoggerFactory;
import ru.yandex.market.logshatter.meta.LogshatterMetaDao;

import java.util.concurrent.ExecutorService;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 05/08/15
 */
public abstract class AbstractReaderService {

    protected static final Logger log = LogManager.getLogger();
    protected BatchErrorLoggerFactory errorLoggerFactory;

    private LogShatterService logShatterService;
    protected ConfigurationService configurationService;
    protected ReadSemaphore readSemaphore;
    protected LogshatterMetaDao logshatterMetaDao;
    protected LogShatterMonitoring monitoring;

    public boolean isRunning() {
        return logShatterService.isRunning();
    }

    protected void addToParseQueue(SourceContext sourceContext) {
        logShatterService.addToParseQueue(sourceContext);
    }

    protected ExecutorService createExecutorService(final int threadCount, String prefix) {
        return logShatterService.createExecutorService(threadCount, prefix);
    }

    @Required
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Required
    public void setReadSemaphore(ReadSemaphore readSemaphore) {
        this.readSemaphore = readSemaphore;
    }

    @Required
    public void setLogShatterService(LogShatterService logShatterService) {
        this.logShatterService = logShatterService;
    }

    @Required
    public void setLogshatterMetaDao(LogshatterMetaDao logshatterMetaDao) {
        this.logshatterMetaDao = logshatterMetaDao;
    }

    @Required
    public void setMonitoring(LogShatterMonitoring monitoring) {
        this.monitoring = monitoring;
    }

    public void setErrorLoggerFactory(BatchErrorLoggerFactory errorLoggerFactory) {
        this.errorLoggerFactory = errorLoggerFactory;
    }
}
