package ru.yandex.market.logshatter.reader;

import java.io.Closeable;
import java.io.IOException;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 14/02/15
 */
public interface LogReader extends Closeable {
    String readLine() throws IOException;

    /**
     * Прочитанная позиция в данный в байтах
     * Отличаеться от getFileOffset() в случае если данные представлены в сжатов виде.
     * В этом случает getDataOffset() возвращает позицию на распарованные данные
     *
     * @return
     * @throws IOException
     */
    long getDataPosition() throws IOException;

    /**
     * Переходит на позицию предварительно полученную функцией getDataOffset()
     *
     * @param dataPosition
     * @throws IOException
     */
    void seek(long dataPosition) throws IOException;

    /**
     * Прочитная позиция в файле в байтах
     * Валидна только после того, как readLine() вернул null
     *
     * @return
     * @throws IOException
     */
    long getFilePosition() throws IOException;

}
