package ru.yandex.market.logshatter.reader;

import org.apache.commons.lang.StringUtils;
import ru.yandex.market.logshatter.LogShatterUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/**
 * @author Nikolay Firov <a href="mailto:firov@yandex-team.ru"></a>
 * @date 25.04.18
 */
public class QueuesLimits {
    private final List<QueueLimit> limits = new ArrayList<>();

    public QueuesLimits() {
    }

    public QueuesLimits(String config) {
        if (StringUtils.isEmpty(config)) {
            return;
        }

        String[] split = config.split(",");
        for (int i = 0; i < split.length; ++i) {
            limits.add(new QueueLimit(split[i], i));
        }
    }

    public List<QueueLimit> getLimits() {
        return limits;
    }

    public static class QueueLimit {
        private final int queueId;
        private final Pattern rule;
        private final long limitBytes;

        QueueLimit(String config, int queueId) {
            this.queueId = queueId;

            String[] split = config.split(":");
            this.rule = Pattern.compile(split[0]);
            this.limitBytes = LogShatterUtil.mbToBytes(Long.parseLong(split[1]));
        }

        public boolean check(String sourceId) {
            return rule.matcher(sourceId).matches();
        }

        public int getQueueId() {
            return queueId;
        }

        public long getLimitBytes() {
            return limitBytes;
        }

        public Pattern getRule() {
            return rule;
        }
    }
}
