package ru.yandex.market.logshatter.reader;

import ru.yandex.market.health.ProcessingQueue;
import ru.yandex.market.logshatter.reader.file.FileContext;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 16/02/15
 */
public class ReadQueue extends ProcessingQueue<FileContext> {

    @Override
    protected boolean isUpdated(FileContext fileContext) {
        if (fileContext.isClosed()) {
            return false;
        }
        return fileContext.isFileUpdated();
    }

    public long bytesToRead() {
        lock.lock();
        long bytesToRead = 0;
        for (FileContext fileContext : queue) {
            bytesToRead += (fileContext.getKnownSizeBytes() - fileContext.getReaderFilePosition());
        }
        lock.unlock();
        return bytesToRead;
    }

}

