package ru.yandex.market.logshatter.reader.file;

import ru.yandex.market.logshatter.reader.LogReader;

import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.nio.file.Paths;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 14/02/15
 */
public class BufferedFileLogReader implements LogReader {

    private InternalBufferedReader reader;
    private RandomAccessFile raf;

    public BufferedFileLogReader(String filename) throws IOException {
        this(Paths.get(filename));
    }

    public BufferedFileLogReader(Path file) throws IOException {
        raf = new RandomAccessFile(file.toFile(), "r");
        reader = new InternalBufferedReader(new FileReader(raf.getFD()));
    }

    @Override
    public String readLine() throws IOException {
        return reader.readLine();
    }

    @Override
    public long getDataPosition() throws IOException {
        return getFilePosition();
    }

    @Override
    public long getFilePosition() throws IOException {
        return raf.getFilePointer() - reader.getUnprocessedBytesCount();
    }

    @Override
    public void seek(long dataPosition) throws IOException {
        raf.seek(dataPosition);
        reader.flushBuffer();
    }

    @Override
    public void close() throws IOException {
        reader.close();
        raf.close();
    }
}
