package ru.yandex.market.logshatter.reader.file;

import org.apache.commons.io.IOUtils;
import ru.yandex.market.logshatter.reader.LogReader;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.GZIPInputStream;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 14/02/15
 */
public class GzipFileLogReader implements LogReader {

    private InternalBufferedReader reader;
    private FileInputStream fis;

    public GzipFileLogReader(String filename) throws IOException {
        this(Paths.get(filename));
    }

    public GzipFileLogReader(Path file) throws IOException {
        fis = new FileInputStream(file.toFile());
        reader = new InternalBufferedReader(new InputStreamReader(new GZIPInputStream(fis)));
    }

    @Override
    public String readLine() throws IOException {
        return reader.readLine();
    }

    @Override
    public long getDataPosition() throws IOException {
        return reader.getProcessedBytesCount();
    }

    @Override
    public long getFilePosition() throws IOException {
        return fis.getChannel().position();
    }

    @Override
    public void seek(long dataPosition) throws IOException {
        if (reader.getProcessedBytesCount() > dataPosition) {
            throw new IOException("Cannot seek back in file");
        }
        long bytesToSkip = dataPosition - reader.getProcessedBytesCount();
        IOUtils.skipFully(reader, bytesToSkip);
    }

    @Override
    public void close() throws IOException {
        reader.close();
    }
}
