package ru.yandex.market.logshatter.reader.logbroker;

import java.util.List;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 31/07/15
 */
final class MessageOffset {
    private final long partitionOffset;
    private final long seqno;
    private final List<LogbrokerSourceContext> sourceContexts;

    public MessageOffset(long partitionOffset, long seqno, List<LogbrokerSourceContext> sourceContexts) {
        this.partitionOffset = partitionOffset;
        this.seqno = seqno;
        this.sourceContexts = sourceContexts;
    }

    public long getPartitionOffset() {
        return partitionOffset;
    }

    public long getSeqno() {
        return seqno;
    }

    public boolean isProcessed() {
        for (int i = 0; i < sourceContexts.size(); i++) {
            LogbrokerSourceContext sourceContext = sourceContexts.get(i);
            if (sourceContext.getSeqno() < seqno) {
                return false;
            }
        }
        return true;
    }
}
