package ru.yandex.market.logshatter.reader.logbroker;

import java.util.Objects;

/**
 * @author Nikolay Firov <a href="mailto:firov@yandex-team.ru"></a>
 * @date 24.04.18
 */
public class MonitoringLagThreshold {
    private double warningPercent;
    private double criticalPercent;

    @SuppressWarnings("unused")
    public MonitoringLagThreshold() {
    }

    public MonitoringLagThreshold(double warningPercent, double criticalPercent) {
        this.warningPercent = warningPercent;
        this.criticalPercent = criticalPercent;
    }

    public double getWarningPercent() {
        return warningPercent;
    }

    public void setWarningPercent(double warningPercent) {
        this.warningPercent = warningPercent;
    }

    public double getCriticalPercent() {
        return criticalPercent;
    }

    public void setCriticalPercent(double criticalPercent) {
        this.criticalPercent = criticalPercent;
    }

    @Override
    public String toString() {
        return "MonitoringLagThreshold{" +
            "warningPercent=" + warningPercent +
            ", criticalPercent=" + criticalPercent +
            '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MonitoringLagThreshold that = (MonitoringLagThreshold) o;
        return Double.compare(that.warningPercent, warningPercent) == 0 &&
            Double.compare(that.criticalPercent, criticalPercent) == 0;
    }

    @Override
    public int hashCode() {

        return Objects.hash(warningPercent, criticalPercent);
    }
}
