package ru.yandex.market.logshatter.reader.logbroker;

import ru.yandex.market.logbroker.pull.LogBrokerClient;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 20.02.2019
 */
public class OldApiLogBrokerClients {
    private final Map<String, LogBrokerClient> dataCenterToLogBrokerClientMap;

    public OldApiLogBrokerClients(Map<String, LogBrokerClient> dataCenterToLogBrokerClientMap) {
        this.dataCenterToLogBrokerClientMap = new HashMap<>(dataCenterToLogBrokerClientMap);
    }

    public Map<String, LogBrokerClient> getAll() {
        return Collections.unmodifiableMap(dataCenterToLogBrokerClientMap);
    }

    public LogBrokerClient get(String dataCenter) {
        return Optional.ofNullable(dataCenterToLogBrokerClientMap.get(dataCenter))
            .orElseThrow(() -> new RuntimeException(
                String.format("There is no LogBroker in data center '%s'", dataCenter)
            ));
    }
}
