package ru.yandex.market.logshatter.reader.logbroker.monitoring;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;
import ru.yandex.common.util.date.DateUtil;
import ru.yandex.market.logbroker.pull.LogBrokerOffset;
import ru.yandex.market.logshatter.reader.logbroker.PartitionDao;

import java.util.Date;
import java.util.Locale;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 17.09.2018
 */
public class LogBrokerLagLogger {
    private static final Logger lbOffsetsLog = LogManager.getLogger("lbOffsets");

    private static final DateUtil.ThreadLocalDateFormat OFFSET_LOG_DATE_FORMAT =
        new DateUtil.ThreadLocalDateFormat("[dd/MMM/yyyy:HH:mm:ss Z]", Locale.US);

    private final PartitionDao partitionDao;

    public LogBrokerLagLogger(PartitionDao partitionDao) {
        this.partitionDao = partitionDao;
    }

    @Scheduled(cron = "0 * * * * *")  // раз в минуту
    public void run() {
        lbOffsetsLog.info(StringUtils.repeat('=', 20));
        lbOffsetsLog.info(OFFSET_LOG_DATE_FORMAT.format(new Date()));
        partitionDao.getAll().stream()
            .map(LogBrokerOffset::format)
            .sorted()
            .forEach(lbOffsetsLog::info);
    }
}
