package ru.yandex.market.logshatter.reader.logbroker.monitoring;

import ru.yandex.market.logshatter.LogShatterMonitoring;
import ru.yandex.market.logshatter.reader.logbroker.MonitoringLagThreshold;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 17.09.2018
 */
public class MonitoringConfig {
    private final LogShatterMonitoring monitoring;

    private final MonitoringLagThreshold defaultLagThreshold;
    private final Map<String, MonitoringLagThreshold> identToLagThreshold;

    private final int readerMonitoringDelayMinutes;

    private final int sourcesWithoutMetadataForCrit;
    private final Set<String> sourcesWithoutMetadataWhitelistLogTypes = Collections.singleton("push-client-log");

    public MonitoringConfig(LogShatterMonitoring monitoring, MonitoringLagThreshold defaultLagThreshold,
                            Map<String, MonitoringLagThreshold> identToLagThreshold,
                            int readerMonitoringDelayMinutes, int sourcesWithoutMetadataForCrit) {
        this.monitoring = monitoring;
        this.defaultLagThreshold = defaultLagThreshold;
        this.identToLagThreshold = identToLagThreshold;
        this.readerMonitoringDelayMinutes = readerMonitoringDelayMinutes;
        this.sourcesWithoutMetadataForCrit = sourcesWithoutMetadataForCrit;
    }

    public MonitoringLagThreshold getThreshold(String ident) {
        return identToLagThreshold.getOrDefault(ident, defaultLagThreshold);
    }

    public int getReaderMonitoringDelayMinutes() {
        return readerMonitoringDelayMinutes;
    }

    public int getSourcesWithoutMetadataForCrit() {
        return sourcesWithoutMetadataForCrit;
    }

    public Set<String> getSourcesWithoutMetadataWhitelistLogTypes() {
        return sourcesWithoutMetadataWhitelistLogTypes;
    }

    public LogShatterMonitoring getMonitoring() {
        return monitoring;
    }
}
