package ru.yandex.market.logshatter.reader.logbroker.monitoring;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;
import ru.yandex.market.logshatter.reader.logbroker.PartitionContext;
import ru.yandex.market.logshatter.reader.logbroker.PartitionManager;
import ru.yandex.market.request.trace.TskvRecordBuilder;

import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 08.11.2018
 */
public class PartitionLeadersDebugLogger {
    private static final Logger log = LogManager.getLogger("partitionsLeadersDebug");

    private final PartitionManager partitionManager;

    public PartitionLeadersDebugLogger(PartitionManager partitionManager) {
        this.partitionManager = partitionManager;
    }

    @Scheduled(cron = "0 * * * * *")  // раз в минуту
    public void run() throws Exception {
        List<PartitionContext> partitionContexts = partitionManager.getPartitionContexts().stream()
            .sorted(Comparator.comparing(PartitionContext::getName))
            .collect(Collectors.toList());

        Instant now = Instant.now();

        for (PartitionContext partitionContext : partitionContexts) {
            log.info(
                new TskvRecordBuilder()
                    .add("date", now)
                    .add("partition", partitionContext.getName())
                    .add("hasLeadership", partitionContext.getLeaderLatch().hasLeadership())
                    .add("leader", partitionContext.getLeaderLatch().getLeader().getId())
                    .build()
            );
        }
    }
}
