package ru.yandex.market.logshatter.reader.logbroker.monitoring;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;
import ru.yandex.market.logshatter.reader.logbroker.PartitionManager;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 17.09.2018
 */
public class PartitionLeadersLogger {
    private static final Logger log = LogManager.getLogger();

    private final PartitionManager partitionManager;

    public PartitionLeadersLogger(PartitionManager partitionManager) {
        this.partitionManager = partitionManager;
    }

    @Scheduled(cron = "0 * * * * *")  // раз в минуту
    public void run() {
        log.info("Leaders of LogBroker partitions: {}", partitionManager.getLeaderStat().toString());
    }
}
