package ru.yandex.market.logshatter.reader.logbroker2;

import com.google.common.util.concurrent.AbstractScheduledService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.market.logshatter.meta.LogshatterMetaDao;
import ru.yandex.market.logshatter.reader.logbroker.LogBrokerConfigurationService;

import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 2019-07-31
 */
public class LogBrokerCleanupService extends AbstractScheduledService {

    private static final Logger log = LogManager.getLogger();

    private final LogBrokerConfigurationService logBrokerConfigurationService;
    private final LogshatterMetaDao logshatterMetaDao;
    private final int runIntervalHours;
    private final int cleanupAfterDays;

    public LogBrokerCleanupService(LogBrokerConfigurationService logBrokerConfigurationService,
                                   LogshatterMetaDao logshatterMetaDao,
                                   int runIntervalHours,
                                   int cleanupAfterDays) {
        this.logBrokerConfigurationService = logBrokerConfigurationService;
        this.logshatterMetaDao = logshatterMetaDao;
        this.runIntervalHours = runIntervalHours;
        this.cleanupAfterDays = cleanupAfterDays;
    }

    @Override
    protected void runOneIteration() throws Exception {
        if (cleanupAfterDays <= 0) {
            return;
        }
        Date cleanupBeforeDate = new Date(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(cleanupAfterDays));
        log.info("Running logbroker source cleanup for sources before {}", cleanupBeforeDate);
        for (String ident : logBrokerConfigurationService.getIdentToSources().keySet()) {
            int deletedCount = logshatterMetaDao.cleanupOldSources(ident, cleanupBeforeDate);
            log.info("Removed {} old sources for ident {}", deletedCount, ident);
        }
        log.info("Cleanup completed");
    }

    @Override
    protected Scheduler scheduler() {
        return Scheduler.newFixedDelaySchedule(0, runIntervalHours, TimeUnit.DAYS);
    }
}
