package ru.yandex.market.logshatter.reader.logbroker2.dc;

import ru.yandex.market.logshatter.LogShatterMonitoring;
import ru.yandex.market.logshatter.reader.logbroker.LogBrokerConfigurationService;
import ru.yandex.market.logshatter.reader.logbroker.OldApiLogBrokerClients;
import ru.yandex.market.logshatter.reader.logbroker.PartitionDao;
import ru.yandex.market.logshatter.reader.logbroker2.threads.SingleThreadExecutorServiceFactory;
import ru.yandex.market.logshatter.reader.logbroker2.topic.LbTopicReaderServiceFactory;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 01.03.2019
 */
public class LbDataCenterReaderServiceFactory {
    private final LbTopicReaderServiceFactory topicReaderServiceFactory;
    private final SingleThreadExecutorServiceFactory singleThreadExecutorServiceFactory;

    private final OldApiLogBrokerClients oldApiLogBrokerClients;
    private final LogBrokerConfigurationService logBrokerConfigurationService;
    private final PartitionDao partitionDao;
    private final LogShatterMonitoring monitoring;

    private final int offsetsFetchingRetryCountUntilCrit;
    private final int offsetsFetchingSleepBetweenRetriesMillis;

    public LbDataCenterReaderServiceFactory(
        LbTopicReaderServiceFactory topicReaderServiceFactory,
        SingleThreadExecutorServiceFactory singleThreadExecutorServiceFactory,
        OldApiLogBrokerClients oldApiLogBrokerClients,
        LogBrokerConfigurationService logBrokerConfigurationService,
        PartitionDao partitionDao,
        LogShatterMonitoring monitoring,
        int offsetsFetchingRetryCountUntilCrit,
        int offsetsFetchingSleepBetweenRetriesMillis
    ) {
        this.topicReaderServiceFactory = topicReaderServiceFactory;
        this.singleThreadExecutorServiceFactory = singleThreadExecutorServiceFactory;
        this.oldApiLogBrokerClients = oldApiLogBrokerClients;
        this.logBrokerConfigurationService = logBrokerConfigurationService;
        this.partitionDao = partitionDao;
        this.monitoring = monitoring;
        this.offsetsFetchingRetryCountUntilCrit = offsetsFetchingRetryCountUntilCrit;
        this.offsetsFetchingSleepBetweenRetriesMillis = offsetsFetchingSleepBetweenRetriesMillis;
    }

    public LbDataCenterReaderService create(String dataCenter) {
        return new LbDataCenterReaderService(
            dataCenter,
            topicReaderServiceFactory,
            singleThreadExecutorServiceFactory,
            new LbOldApiOffsetsFetcher(
                dataCenter,
                oldApiLogBrokerClients.get(dataCenter),
                offsetsFetchingRetryCountUntilCrit,
                offsetsFetchingSleepBetweenRetriesMillis
            ),
            logBrokerConfigurationService.getSources(),
            partitionDao,
            monitoring
        );
    }
}
