package ru.yandex.market.logshatter.reader.logbroker2.threads;

import com.google.common.util.concurrent.ThreadFactoryBuilder;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 23.01.2019
 */
public class SingleThreadExecutorServiceFactoryImpl implements SingleThreadExecutorServiceFactory {
    @Override
    public ScheduledExecutorService create(String nameFormat) {
        return Executors.newSingleThreadScheduledExecutor(
            new ThreadFactoryBuilder()
                .setNameFormat(nameFormat)
                .build()
        );
    }
}
