package ru.yandex.market.logshatter.reader.logbroker2.topic;

import ru.yandex.market.logshatter.LogShatterService;
import ru.yandex.market.logshatter.logging.BatchErrorLoggerFactory;
import ru.yandex.market.logshatter.meta.LogshatterMetaDao;
import ru.yandex.market.logshatter.reader.ReadSemaphore;
import ru.yandex.market.logshatter.reader.logbroker.LogBrokerConfigurationService;
import ru.yandex.market.logshatter.reader.logbroker.LogBrokerPartitionSourceContextsStorage;
import ru.yandex.market.logshatter.reader.logbroker.PartitionDao;
import ru.yandex.market.logshatter.reader.logbroker.monitoring.LogBrokerSourcesWithoutMetadataMonitoring;
import ru.yandex.market.logshatter.reader.logbroker2.common.TopicId;
import ru.yandex.market.logshatter.reader.logbroker2.threads.SingleThreadExecutorServiceFactory;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 26.12.2018
 */
public class LbTopicReaderServiceFactory {
    private final SingleThreadExecutorServiceFactory singleThreadExecutorServiceFactory;
    private final LbApiStreamConsumerFactory streamConsumerFactory;
    private final PartitionDao partitionDao;
    private final ReadSemaphore readSemaphore;
    private final LogShatterService logShatterService;

    private final LogBrokerConfigurationService logBrokerConfigurationService;
    private final LogshatterMetaDao logshatterMetaDao;
    private final LogBrokerSourcesWithoutMetadataMonitoring sourcesWithoutMetadataMonitoring;
    private final BatchErrorLoggerFactory errorLoggerFactory;

    public LbTopicReaderServiceFactory(
        SingleThreadExecutorServiceFactory singleThreadExecutorServiceFactory,
        LbApiStreamConsumerFactory streamConsumerFactory,
        PartitionDao partitionDao,
        ReadSemaphore readSemaphore,
        LogShatterService logShatterService,
        LogBrokerConfigurationService logBrokerConfigurationService,
        LogshatterMetaDao logshatterMetaDao,
        LogBrokerSourcesWithoutMetadataMonitoring sourcesWithoutMetadataMonitoring,
        BatchErrorLoggerFactory errorLoggerFactory
    ) {
        this.singleThreadExecutorServiceFactory = singleThreadExecutorServiceFactory;
        this.streamConsumerFactory = streamConsumerFactory;
        this.partitionDao = partitionDao;
        this.readSemaphore = readSemaphore;
        this.logShatterService = logShatterService;
        this.logBrokerConfigurationService = logBrokerConfigurationService;
        this.logshatterMetaDao = logshatterMetaDao;
        this.sourcesWithoutMetadataMonitoring = sourcesWithoutMetadataMonitoring;
        this.errorLoggerFactory = errorLoggerFactory;
    }

    public LbTopicReaderService create(TopicId topicId) {
        return new LbTopicReaderService(
            topicId,
            singleThreadExecutorServiceFactory,
            streamConsumerFactory,
            partitionDao,
            readSemaphore,
            new LogBrokerPartitionSourceContextsStorage(
                logBrokerConfigurationService,
                readSemaphore,
                logshatterMetaDao,
                sourcesWithoutMetadataMonitoring,
                errorLoggerFactory
            ),
            logShatterService
        );
    }
}
