package ru.yandex.market.logshatter.reader.startrek;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Vlad Vinogradov <a href="mailto:vladvin@yandex-team.ru"></a> on 14.12.16
 */
public class StarTrekLine {
    public enum OptField {
        PROJECT,
        RESOLVER,
        RESOLUTION,
        STAND,
        SRE_BEGIN_TIME,
        SRE_NOTIFICATION_TIME,
        SRE_END_TIME,
        WEIGHT,
        ISSUE_WEIGHT
    }

    private long lastParsingMillis;
    private long created;
    private long updated;
    private long resolved;
    private String issue;
    private String queue;
    private String type;
    private String priority;
    private List<String> components;
    private String createdBy;
    private String status;
    private List<StarTrekHistoryEvent> history;
    private List<String> tags;
    private boolean testScope;
    private Map<OptField, Object> optionalFields = new HashMap<>();
    private String assignee;

    public <T> void setOptional(OptField optField, T value) {
        if (optField != null && value != null) {
            optionalFields.put(optField, value);
        }
    }

    public <T> T getOptionalOrDefault(OptField optField, Class<T> valueClass, T defaultValue) {
        return valueClass.cast(optionalFields.getOrDefault(optField, defaultValue));
    }

    public long getCreated() {
        return created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public long getUpdated() {
        return updated;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }

    public long getResolved() {
        return resolved;
    }

    public void setResolved(long resolved) {
        this.resolved = resolved;
    }

    public String getIssue() {
        return issue;
    }

    public void setIssue(String issue) {
        this.issue = issue;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPriority() {
        return priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public List<StarTrekHistoryEvent> getHistory() {
        return history;
    }

    public void setHistory(List<StarTrekHistoryEvent> history) {
        this.history = history;
    }

    public String getQueue() {
        return queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public List<String> getComponents() {
        return components;
    }

    public void setComponents(List<String> components) {
        this.components = components;
    }

    public String getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean isTestScope() {
        return testScope;
    }

    public void setTestScope(boolean testScope) {
        this.testScope = testScope;
    }

    public long getLastParsingMillis() {
        return lastParsingMillis;
    }

    public void setLastParsingMillis(long lastParsingMillis) {
        this.lastParsingMillis = lastParsingMillis;
    }

    public String getAssignee() {
        return assignee;
    }

    public StarTrekLine setAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }
}
