package ru.yandex.market.logshatter.reader.startrek;

import ru.yandex.market.logshatter.config.LogShatterConfig;
import ru.yandex.market.logshatter.config.LogSource;
import ru.yandex.market.logshatter.logging.BatchErrorLoggerFactory;
import ru.yandex.market.logshatter.reader.ReadSemaphore;
import ru.yandex.market.logshatter.reader.SourceContext;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;

/**
 * @author imelnikov
 */
public class StartrekSourceContext extends SourceContext {

    private BatchErrorLoggerFactory errorLoggerFactory;

    public StartrekSourceContext(LogShatterConfig logShatterConfig, LogSource logSource,
                                 BatchErrorLoggerFactory errorLoggerFactory,
                                 ReadSemaphore.QueuesCounter queuesCounter) {
        super(logShatterConfig, "startrek", logSource.getPath(), errorLoggerFactory, queuesCounter);
        this.logSource = logSource;
    }

    private final LogSource logSource;

    private volatile long lastTimestamp;

    // last timestamp before storing in db
    private volatile long readerLastTimestamp;

    public long getReaderLastTimestamp() {
        return readerLastTimestamp;
    }

    public void setReaderLastTimestamp(long readerLastTimestamp) {
        this.readerLastTimestamp = readerLastTimestamp;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public String getHost() {
        return "StartrekApi";
    }

    @Override
    public Path getPath() {
        return Paths.get(logSource.getUri());
    }

    @Override
    public long getDataOffset() {
        return lastTimestamp;
    }

    @Override
    public void setDataOffset(long dataOffset) {
        lastTimestamp = dataOffset;
    }

    @Override
    public long getFileOffset() {
        return 0;
    }

    @Override
    public void setFileOffset(long fileOffset) {
        // Ignored
    }

    @Override
    public String getName() {
        return logSource.getPath();
    }

    @Override
    public int getInstanceId() {
        return 0;
    }
}
