package ru.yandex.market.logshatter.rotation;

public class ObsoletePartition {
    private final String host;
    private final String table;
    private final String partition;
    private final String dropQuery;

    public ObsoletePartition(String host, String table, String partition) {
        this.host = host;
        this.table = table;
        this.partition = partition;
        this.dropQuery = "ALTER TABLE " + table + " DROP PARTITION " + partition;
    }

    public String getHost() {
        return host;
    }

    public String getTable() {
        return table;
    }

    public String getPartition() {
        return partition;
    }

    public String getDropQuery() {
        return dropQuery;
    }

}
