package ru.yandex.market.logshatter.spring;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseDataSource;
import ru.yandex.clickhouse.settings.ClickHouseProperties;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 12/05/2017
 */
@Configuration
public class LogshatterSpringClickHouseConfig {

    @Value("${logshatter.clickhouse.host}")
    private String clickHouseHost;

    @Value("${logshatter.clickhouse.port}")
    private int clickHousePort;

    @Value("${logshatter.clickhouse.ssl}")
    private boolean ssl;

    @Value("${logshatter.clickhouse.ssl-mode}")
    private String sslMode;

    @Value("${logshatter.clickhouse.user}")
    private String clickHouseUser;

    @Value("${logshatter.clickhouse.password}")
    private String clickHousePassword;

    @Value("${logshatter.clickhouse.db}")
    private String clickHouseDatabase;

    @Value("${logshatter.clickhouse.compress}")
    private boolean clickHouseCompress;

    @Value("${logshatter.clickhouse.socket-timeout-seconds}")
    private int clickHouseSocketTimeoutSeconds;

    @Value("${logshatter.clickhouse.query-timeout-seconds}")
    private int clickHouseQueryTimeoutSeconds;

    @Value("${logshatter.clickhouse.connection-timeout-millis}")
    private int clickHouseConnectionTimeoutMillis;

    @Bean
    public ClickHouseDataSource clickHouseDataSource() {
        String url = "jdbc:clickhouse://" + clickHouseHost + ":" + clickHousePort + "/" + clickHouseDatabase;
        ClickHouseProperties clickHouseProperties = new ClickHouseProperties();
        clickHouseProperties.setSsl(ssl);
        clickHouseProperties.setSslMode(sslMode);
        clickHouseProperties.setSocketTimeout((int) TimeUnit.SECONDS.toMillis(clickHouseSocketTimeoutSeconds));
        clickHouseProperties.setConnectionTimeout(clickHouseConnectionTimeoutMillis);
        clickHouseProperties.setUser(clickHouseUser);
        clickHouseProperties.setPassword(clickHousePassword);
        clickHouseProperties.setCompress(clickHouseCompress);
        clickHouseProperties.setDecompress(clickHouseCompress);
        return new ClickHouseDataSource(url, clickHouseProperties);
    }

    @Bean
    public JdbcTemplate clickHouseJdbcTemplate() {
        final JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.setDataSource(clickHouseDataSource());
        jdbcTemplate.setQueryTimeout(clickHouseQueryTimeoutSeconds);
        return jdbcTemplate;
    }

    @Bean
    public ClickHouseConnection clickHouseConnection() throws SQLException {
        return clickHouseDataSource().getConnection();
    }

}
