package ru.yandex.market.logshatter.spring;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.servlet.support.AbstractAnnotationConfigDispatcherServletInitializer;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 18/10/2017
 */
@Configuration
public class LogshatterSpringJettyConfig {

    @Autowired
    private ApplicationContext applicationContext;

    @Value("${logshatter.http.port}")
    private int httpPort;

    @Bean(initMethod = "start", destroyMethod = "stop")
    public Server logshatterJettyServer() {
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setContextPath("/");
        webAppContext.setResourceBase("/");

        GenericWebApplicationContext webApplicationContext = new GenericWebApplicationContext();
        webApplicationContext.setParent(applicationContext);
        webApplicationContext.refresh();

        webAppContext.setParentLoaderPriority(true);

        webAppContext.addEventListener(new ContextLoaderListener(webApplicationContext));
        webAppContext.addEventListener(
            new WebAppInitializerLoader(new WebApplicationInitializer[]{
                new WebInitializer(LogshatterSpringMvcConfig.class)
            })
        );

        Server server = new Server();

        ServerConnector httpConnector = new ServerConnector(server);
        httpConnector.setPort(httpPort);
        server.addConnector(httpConnector);

        server.setHandler(webAppContext);
        return server;

    }

    private static class WebAppInitializerLoader implements ServletContextListener {

        private WebApplicationInitializer[] initializers;

        private WebAppInitializerLoader(WebApplicationInitializer[] initializers) {
            this.initializers = initializers;
        }

        @Override
        public void contextInitialized(ServletContextEvent servletContextEvent) {
            for (WebApplicationInitializer initializer : initializers) {
                try {
                    initializer.onStartup(servletContextEvent.getServletContext());
                } catch (ServletException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void contextDestroyed(ServletContextEvent servletContextEvent) {
        }
    }

    private static class WebInitializer extends AbstractAnnotationConfigDispatcherServletInitializer {

        private final Class<?>[] servletConfigClasses;

        private WebInitializer(Class<?>[] servletConfigClasses) {
            this.servletConfigClasses = servletConfigClasses;
        }

        private WebInitializer(Class<?> clazz) {
            servletConfigClasses = new Class<?>[]{clazz};
        }

        @Override
        protected Class<?>[] getRootConfigClasses() {
            return null;
        }

        @Override
        protected Class<?>[] getServletConfigClasses() {
            return servletConfigClasses;
        }

        @Override
        protected String[] getServletMappings() {
            return new String[]{"/"};
        }

        @Override
        protected String getServletName() {
            return "logshatter";
        }
    }

}
