package ru.yandex.market.logshatter.spring;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import ru.yandex.market.health.HealthMetaDao;
import ru.yandex.market.logshatter.meta.LogshatterMetaDao;

/**
 * @author Alexander Kedrik <a href="mailto:alkedr@yandex-team.ru"></a>
 * @date 12.12.2018
 */
public class LogshatterSpringMongoConfig {
    @Bean
    public HealthMetaDao healthMetaDao(
        @Value("${logshatter.mongo.health-url}") String mongoUrl,
        @Value("${logshatter.mongo.health-db}") String dbName,
        @Value("${logshatter.mongo.connect-timeout-millis}") int connectTimeoutMillis,
        @Value("${logshatter.mongo.socket-timeout-millis}") int socketTimeoutMillis,
        @Value("${logshatter.mongo.replica-set}") String replicaSet,
        @Value("${logshatter.mongo.ssl}") boolean ssl
    ) {
        return new HealthMetaDao(mongoUrl, dbName, connectTimeoutMillis, socketTimeoutMillis, replicaSet, ssl);
    }

    @Bean
    public LogshatterMetaDao logshatterMetaDao(
        @Value("${logshatter.mongo.main-url}") String mongoUrl,
        @Value("${logshatter.mongo.main-db}") String dbName,
        @Value("${logshatter.mongo.connect-timeout-millis}") int connectTimeoutMillis,
        @Value("${logshatter.mongo.socket-timeout-millis}") int socketTimeoutMillis,
        @Value("${logshatter.mongo.replica-set}") String replicaSet,
        @Value("${logshatter.mongo.ssl}") boolean ssl
    ) {
        return new LogshatterMetaDao(mongoUrl, dbName, connectTimeoutMillis, socketTimeoutMillis, replicaSet, ssl);
    }
}
