package ru.yandex.market.logshatter.url;

import java.util.Objects;

public final class Level {

    public enum Type {
        METHOD,
        PATH,
        QUERY
    }

    private final String name;
    private final Type type;

    public Level(String name, Type type) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
    }

    public String getName() {
        return name;
    }

    public Type getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Level level = (Level) o;

        if (!name.equals(level.name)) {
            return false;
        }
        return type == level.type;

    }

    @Override
    public int hashCode() {
        int result = name.hashCode();
        result = 31 * result + type.hashCode();
        return result;
    }
}
