package ru.yandex.market.logshatter.url;

import ru.yandex.market.logshatter.parser.ParseUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Levels {

    private Levels() {
    }

    public static List<Level> parse(String pattern) {
        int colonIndex = pattern.indexOf(':');
        String method;
        String url;
        if (colonIndex >= 0) {
            method = pattern.substring(0, colonIndex);
            url = pattern.substring(colonIndex + 1);
        } else {
            method = "<all>";
            url = pattern;
        }
        return parse(method, url);
    }

    public static List<Level> parse(String method, String url) {
        url = url.toLowerCase();
        Stream<Level> levels = Stream.of(new Level(method.toLowerCase(), Level.Type.METHOD));

        String[] lnames = ParseUtils.splitPatternToLevels(url);
        levels = Stream.concat(levels, Arrays.stream(lnames).map(ln -> new Level(ln, Level.Type.PATH)));

        String paramsSubstring = ParseUtils.extractParamsSubstring(url);
        if (paramsSubstring.isEmpty()) {
            return levels.collect(Collectors.toList());
        }

        String[] params = paramsSubstring.split("&");
        levels = Stream.concat(levels, Arrays.stream(params).sorted().map(ln -> new Level(ln, Level.Type.QUERY)));
        return levels.collect(Collectors.toList());
    }

}
