package ru.yandex.market.logshatter.url;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 15/04/15
 */
public class Page {
    private final String id;
    private final String pattern;
    private final String type;
    private final Instant reloadInstant;
    private final List<Level> levels;

    public static final Page EMPTY = new Page("", "", "", Instant.MIN, Collections.emptyList());

    public static List<Page> parsePages(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line;
        List<Page> pages = new ArrayList<>();
        while ((line = reader.readLine()) != null) {
            String[] splits = line.split("\t");
            pages.add(new Page(splits[0], splits[1], splits[2], Instant.MIN));
        }
        return pages;
    }

    public Page(String id, String type) {
        this(id, "", type, Instant.MIN, Collections.emptyList());
    }

    public Page(String id, String pattern, String type, Instant reloadInstant) {
        this(id, pattern, type, reloadInstant, Levels.parse(pattern));
    }

    private Page(String id, String pattern, String type, Instant reloadInstant, List<Level> levels) {
        this.id = id;
        this.pattern = pattern.toLowerCase();
        this.type = type;
        this.reloadInstant = reloadInstant;
        this.levels = levels;
    }

    public boolean hasLevel(int level) {
        return levels.size() > level;
    }

    public Level getLevel(int level) {
        return levels.get(level);
    }

    public String getId() {
        return id;
    }

    public String getPattern() {
        return pattern;
    }

    public String getType() {
        return type;
    }

    public Instant getReloadInstant() {
        return reloadInstant;
    }

    @Override
    public String toString() {
        return "Page{" +
            "type='" + type + '\'' +
            ", pattern='" + pattern + '\'' +
            ", id='" + id + '\'' +
            ", reloadInstant=" + reloadInstant +
            '}';
    }
}
