package ru.yandex.market.logshatter.useragent;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import ru.yandex.uatraits.Detector;
import ru.yandex.uatraits.util.JniUtils;

import java.util.Map;
import java.util.function.Function;

public class UatraitsUserAgentDetector implements UserAgentDetector {
    private final ThreadLocal<Detector> detector = ThreadLocal.withInitial(UatraitsUserAgentDetector::createDetector);
    private final Function<String, Map<String, String>> cache;

    public UatraitsUserAgentDetector() {
        this(-1);
    }

    public UatraitsUserAgentDetector(int cacheSize) {
        if (cacheSize > 0) {
            cache = CacheBuilder.newBuilder()
                .maximumSize(cacheSize)
                .build(new CacheLoader<String, Map<String, String>>() {
                    @Override
                    public Map<String, String> load(String userAgent) {
                        return doDetect(userAgent);
                    }
                });

        } else {
            cache = this::doDetect;
        }
    }

    private static synchronized Detector createDetector() {
        // TODO поставляемый в jar файл browser.xml немного устарел - надо подумать над обновлением
        String browserPath = "/data/browser.xml";
        if (UatraitsUserAgentDetector.class.getResource("/data-override/browser.xml") != null) {
            browserPath = "/data-override/browser.xml";
        }
        String profilesPath = "/data/profiles.xml";
        if (UatraitsUserAgentDetector.class.getResource("/data-override/profiles.xml") != null) {
            profilesPath = "/data-override/profiles.xml";
        }
        String extraPath = "/data/extra.xml";
        if (UatraitsUserAgentDetector.class.getResource("/data-override/extra.xml") != null) {
            extraPath = "/data-override/extra.xml";
        }
        String browser = JniUtils.moveToTempQuietly(browserPath);
        String profiles = JniUtils.moveToTempQuietly(profilesPath);
        String extra = JniUtils.moveToTempQuietly(extraPath);
        // TODO проверить очистку временного каталога
        return new Detector(browser, profiles, extra);
    }

    private Map<String, String> doDetect(String userAgent) {
        return detector.get().detect(userAgent);
    }

    @Override
    public Map<String, String> detect(String userAgent) {
        return cache.apply(userAgent);
    }
}
