package ru.yandex.market.logshatter.parser.delivery;

import org.junit.Test;
import ru.yandex.market.logshatter.parser.LogParserChecker;

import java.util.Date;

/**
 * @author Aleksandr Svintsov svintsov@yandex-team.ru
 *         17.05.16.
 */
public class DeliveryOpenApiLogParserTest {
    static LogParserChecker checker = new LogParserChecker(new DeliveryOpenApiLogParser());

    @Test
    public void testParser() throws Exception {
        checker.check(
            "[2016-05-18 03:35:18] OpenApi:INFO:createorder: REQUEST [] {\"memoryPeakUsage\":\"24136544\",\"httpCode\":\"200\",\"executionTime\":\"00:00:33\",\"request\":\"{\\\"client_id\\\":\\\"79\\\",\\\"sender_id\\\":\\\"3\\\",\\\"order_num\\\":\\\"1589123\\\",\\\"recipient_first_name\\\":\\\"\\\\u0421\\\\u0435\\\\u0440\\\\u0433\\\\u0435\\\\u0439\\\",\\\"recipient_last_name\\\":\\\"\\\\u0418\\\\u0432\\\\u0430\\\\u043d\\\\u043e\\\\u0432\\\",\\\"recipient_phone\\\":\\\"87776665544\\\",\\\"recipient_email\\\":\\\"mail@yandex.ru\\\",\\\"order_comment\\\":\\\"\\\\u0414\\\\u043e\\\\u043f.\\\\u0442\\\\u0435\\\\u043b\\\\u0435\\\\u0444\\\\u043e\\\\u043d: +7(916)123-45-67\\\",\\\"order_weight\\\":\\\"1\\\",\\\"order_length\\\":\\\"10\\\",\\\"order_width\\\":\\\"10\\\",\\\"order_height\\\":\\\"10\\\",\\\"order_requisite\\\":\\\"42\\\",\\\"order_warehouse\\\":\\\"63\\\",\\\"order_payment_method\\\":\\\"3\\\",\\\"order_assessed_value\\\":\\\"1200\\\",\\\"order_amount_prepaid\\\":\\\"1200\\\",\\\"order_delivery_cost\\\":\\\"300\\\",\\\"is_manual_delivery_cost\\\":\\\"1\\\",\\\"deliverypoint_city\\\":\\\"\\\\u0422\\\\u044e\\\\u043c\\\\u0435\\\\u043d\\\\u044c\\\",\\\"deliverypoint_street\\\":\\\"\\\\u043f\\\\u0440-\\\\u043a\\\\u0442 \\\\u041b\\\\u0435\\\\u043d\\\\u0438\\\\u043d\\\\u0430\\\",\\\"deliverypoint_house\\\":\\\"60\\\\u0410\\\",\\\"deliverypoint_housing\\\":\\\"1\\\",\\\"deliverypoint_build\\\":\\\"2\\\",\\\"deliverypoint_flat\\\":\\\"3\\\",\\\"deliverypoint_index\\\":\\\"111111\\\",\\\"delivery_delivery\\\":\\\"28\\\",\\\"delivery_direction\\\":\\\"714\\\",\\\"delivery_tariff\\\":\\\"170\\\",\\\"delivery_pickuppoint\\\":\\\"\\\",\\\"delivery_to_yd_warehouse\\\":\\\"1\\\",\\\"order_items\\\":[{\\\"orderitem_article\\\":\\\"abcd1\\\",\\\"orderitem_name\\\":\\\"\\\\u0422\\\\u043e\\\\u0432\\\\u0430\\\\u04401\\\",\\\"orderitem_quantity\\\":\\\"1\\\",\\\"orderitem_cost\\\":\\\"200\\\"},{\\\"orderitem_article\\\":\\\"abcd2\\\",\\\"orderitem_name\\\":\\\"\\\\u0422\\\\u043e\\\\u0432\\\\u0430\\\\u04402\\\",\\\"orderitem_quantity\\\":\\\"5\\\",\\\"orderitem_cost\\\":\\\"200\\\"}],\\\"secret_key\\\":\\\"e9cb87b0033a6d19077dc3e46edad407\\\"}\",\"response\":\"s:16855:\\\"{\\\"status\\\":\\\"ok\\\",\\\"data\\\":{\\\"order\\\":{\\\"delivery_order_status\\\":0,\\\"to_yd_warehouse\\\":1,\\\"cancelled\\\":0,\\\"amount_prepaid\\\":1200,\\\"is_trackable\\\":false,\\\"archived\\\":0,\\\"is_manual_delivery_cost\\\":1,\\\"billing_order_created\\\":0,\\\"status_id\\\":\\\"1\\\",\\\"total_cost\\\":300,\\\"num\\\":1589123,\\\"weight\\\":1,\\\"length\\\":10,\\\"height\\\":10,\\\"width\\\":10,\\\"assessed_value\\\":1200,\\\"requisite_id\\\":42,\\\"warehouse_id\\\":63,\\\"sender_id\\\":3,\\\"comment\\\":\\\"\\\\u0414\\\\u043e\\\\u043f.\\\\u0442\\\\u0435\\\\u043b\\\\u0435\\\\u0444\\\\u043e\\\\u043d: +7(916)123-45-67\\\",\\\"cash_service_percent\\\":\\\"0.022000\\\",\\\"offer_days\\\":\\\"3-4\\\",\\\"delivery_id\\\":28,\\\"tariff_id\\\":170,\\\"delivery_method\\\":\\\"TODOOR\\\",\\\"delivery_interval_id\\\":508,\\\"recipient_id\\\":\\\"156770\\\",\\\"user_id\\\":\\\"71\\\",\\\"resource_id\\\":\\\"79\\\",\\\"created\\\":{\\\"expression\\\":\\\"NOW()\\\",\\\"params\\\":[]},\\\"documentable_id\\\":\\\"180608\\\",\\\"billing_entity_id\\\":194126,\\\"id\\\":\\\"157337\\\",\\\"parcel_id\\\":null,\\\"fulfillment_parcel_id\\\":null,\\\"updated\\\":null,\\\"fulfillment_id\\\":null,\\\"return_fulfillment_id\\\":null,\\\"tariff_changed\\\":null,\\\"delivery_num\\\":null,\\\"fulfillment_num\\\":null,\\\"return_fulfillment_num\\\":null,\\\"delivery_status_update\\\":null,\\\"status\\\":\\\"DRAFT\\\",\\\"fact_weight\\\":null,\\\"trackable_date\\\":null,\\\"full_num\\\":\\\"1589123-YD157337\\\",\\\"status_label\\\":\\\"\\\\u0427\\\\u0435\\\\u0440\\\\u043d\\\\u043e\\\\u0432\\\\u0438\\\\u043a\\\",\\\"items_cost\\\":1200,\\\"sender\\\":{\\\"id\\\":\\\"3\\\",\\\"real\\\":\\\"0\\\",\\\"real_request\\\":\\\"0\\\",\\\"resource_id\\\":\\\"79\\\",\\\"created\\\":\\\"2015-05-29 19:55:53\\\",\\\"updated\\\":\\\"2016-04-25 16:55:18\\\",\\\"user_id\\\":\\\"71\\\",\\\"field_url\\\":\\\"http:\\\\/\\\\/desfirst.com\\\",\\\"phone_id\\\":\\\"9\\\",\\\"field_name\\\":\\\"DesFirsT\\\",\\\"field_image\\\":\\\"\\\",\\\"insurance_in_cost\\\":\\\"0\\\",\\\"cash_service_in_cost\\\":\\\"0\\\",\\\"balance\\\":\\\"0.00\\\",\\\"credit_percent\\\":\\\"0\\\",\\\"default_item_description\\\":\\\"\\\",\\\"emails_to_notify\\\":\\\"yndx.dlvry@yandex.ru\\\",\\\"support_type\\\":\\\"ACCOUNT\\\",\\\"is_deleted\\\":\\\"0\\\",\\\"sales_id\\\":null,\\\"deal_id\\\":null,\\\"support_id\\\":null,\\\"new_rules_active\\\":\\\"1\\\",\\\"is_archived\\\":\\\"0\\\",\\\"archived_at\\\":null,\\\"status\\\":\\\"1\\\",\\\"contact_first_name\\\":\\\"\\\\u0410\\\\u043d\\\\u0434\\\\u0440\\\\u0435\\\\u0439\\\",\\\"contact_last_name\\\":\\\"\\\",\\\"contact_middle_name\\\":\\\"\\\",\\\"status_change_reason\\\":\\\"\\\"},\\\"requisite\\\":{\\\"id\\\":\\\"42\\\",\\\"resource_id\\\":\\\"60\\\",\\\"phone_id\\\":\\\"1491\\\",\\\"accountant_phone_id\\\":\\\"1494\\\",\\\"fax_id\\\":\\\"1488\\\",\\\"address_legal_id\\\":\\\"1128\\\",\\\"address_match\\\":null,\\\"address_post_id\\\":\\\"1125\\\",\\\"contact_first_name\\\":\\\"\\\",\\\"contact_middle_name\\\":\\\"\\\",\\\"contact_last_name\\\":\\\"\\\",\\\"contact_email\\\":\\\"luba@buhgalter.biz;n.kotov.qcyber@gmail.com\\\",\\\"legal_type\\\":\\\"company\\\",\\\"legal_form\\\":\\\"\\\\u041e\\\\u041e\\\\u041e\\\",\\\"legal_name\\\":\\\"\\\\u041a\\\\u042c\\\\u042e\\\\u0421\\\\u0410\\\\u0419\\\\u0411\\\\u0415\\\\u0420 \\\\u0422\\\\u0420\\\\u0415\\\\u0419\\\\u0414\\\\u0418\\\\u041d\\\\u0413\\\",\\\"legal_inn\\\":\\\"7714945434\\\",\\\"accountant_fullname\\\":\\\"\\\\u041b\\\\u044e\\\\u0431\\\\u043e\\\\u0432\\\\u044c \\\\u0418\\\\u0432\\\\u0430\\\\u043d\\\\u043e\\\\u0432\\\\u043d\\\\u0430 \\\\u0413\\\\u0443\\\\u0441\\\\u0430\\\\u0440\\\\u043e\\\\u0432\\\\u0430\\\",\\\"accountant_email\\\":\\\"\\\",\\\"taxes\\\":\\\"no\\\",\\\"payment_form\\\":\\\"POST\\\",\\\"person_type\\\":\\\"\\\\u0413\\\\u0435\\\\u043d\\\\u0435\\\\u0440\\\\u0430\\\\u043b\\\\u044c\\\\u043d\\\\u044b\\\\u0439 \\\\u0434\\\\u0438\\\\u0440\\\\u0435\\\\u043a\\\\u0442\\\\u043e\\\\u0440\\\",\\\"person_fullname\\\":\\\"\\\\u041a\\\\u043e\\\\u0442\\\\u043e\\\\u0432 \\\\u041d\\\\u0438\\\\u043a\\\\u043e\\\\u043b\\\\u0430\\\\u0439 \\\\u0414\\\\u043c\\\\u0438\\\\u0442\\\\u0440\\\\u0438\\\\u0435\\\\u0432\\\\u0438\\\\u0447\\\",\\\"person_formation\\\":\\\"\\\\u0423\\\\u0441\\\\u0442\\\\u0430\\\\u0432\\\",\\\"bank_kpp\\\":\\\"771401001\\\",\\\"bank_bik\\\":\\\"044525593\\\",\\\"bank_account\\\":\\\"40702810102810000397\\\",\\\"bank_korr_account\\\":\\\"\\\",\\\"bank_name\\\":\\\"\\\\u041e\\\\u0410\\\\u041e \\\\u0410\\\\u041b\\\\u042c\\\\u0424\\\\u0410-\\\\u0411\\\\u0410\\\\u041d\\\\u041a\\\",\\\"billing_person_id\\\":\\\"2480582\\\",\\\"billing_current_contract_id\\\":\\\"216337\\\",\\\"billing_current_contract_active\\\":\\\"1\\\",\\\"last_contract_tracked_time\\\":\\\"2016-05-12 20:45:21\\\",\\\"created\\\":\\\"2015-06-04 14:08:38\\\",\\\"updated\\\":\\\"2016-05-12 18:30:33\\\",\\\"is_deleted\\\":\\\"0\\\",\\\"legal_ogrn\\\":\\\"5147746115941\\\",\\\"legal_ogrnip\\\":\\\"0\\\",\\\"ogrn_date\\\":\\\"2014-04-19\\\",\\\"legal_kpp\\\":\\\"771401001\\\",\\\"status\\\":\\\"accepted\\\",\\\"billing_current_contract_date_start\\\":\\\"2015-04-30\\\",\\\"bank_location_id\\\":\\\"213\\\",\\\"status_change_reason\\\":null,\\\"is_archived\\\":\\\"0\\\",\\\"archived_at\\\":null,\\\"contract_delivery_type\\\":\\\"russian-post\\\"},\\\"warehouse\\\":{\\\"id\\\":\\\"63\\\",\\\"resource_id\\\":\\\"270\\\",\\\"code\\\":null,\\\"field_name\\\":\\\"\\\\u0424\\\\u043e\\\\u043d\\\\u043e\\\\u041c\\\\u0430\\\\u043d\\\\u0438\\\\u044f\\\",\\\"field_howtogo\\\":\\\"\\\",\\\"field_worktime\\\":\\\"\\\",\\\"contact_name\\\":\\\"\\\\u0424\\\\u043e\\\\u043d\\\\u043e\\\\u041c\\\\u0430\\\\u043d\\\\u0438\\\\u044f\\\",\\\"contact_surname\\\":\\\"\\\",\\\"contact_patronymic\\\":\\\"\\\",\\\"created\\\":\\\"2015-07-06 13:38:44\\\",\\\"updated\\\":null,\\\"address_id\\\":\\\"9561\\\",\\\"is_deleted\\\":\\\"0\\\",\\\"is_archived\\\":\\\"0\\\",\\\"is_freezed\\\":\\\"0\\\",\\\"archived_at\\\":null},\\\"parcel\\\":[],\\\"recipient\\\":{\\\"is_company\\\":false,\\\"first_name\\\":\\\"\\\\u0421\\\\u0435\\\\u0440\\\\u0433\\\\u0435\\\\u0439\\\",\\\"last_name\\\":\\\"\\\\u0418\\\\u0432\\\\u0430\\\\u043d\\\\u043e\\\\u0432\\\",\\\"middle_name\\\":null,\\\"email\\\":\\\"mail@yandex.ru\\\",\\\"comment\\\":null,\\\"direction_id\\\":\\\"714\\\",\\\"pickuppoint_id\\\":null,\\\"created\\\":{\\\"expression\\\":\\\"NOW()\\\",\\\"params\\\":[]},\\\"address_id\\\":\\\"519770\\\",\\\"id\\\":\\\"156770\\\",\\\"updated\\\":null,\\\"metro_station\\\":null,\\\"company_name\\\":null,\\\"company_inn\\\":null,\\\"is_pickuppoint\\\":false,\\\"pickuppoint\\\":[],\\\"full_address\\\":\\\"111111, \\\\u0422\\\\u044e\\\\u043c\\\\u0435\\\\u043d\\\\u044c, \\\\u043f\\\\u0440-\\\\u043a\\\\u0442 \\\\u041b\\\\u0435\\\\u043d\\\\u0438\\\\u043d\\\\u0430, 60\\\\u0410, \\\\u0441\\\\u0442\\\\u0440. 2, \\\\u043a\\\\u043e\\\\u0440\\\\u043f. 1, \\\\u043a\\\\u0432. 3\\\",\\\"address\\\":{\\\"location_id\\\":\\\"55\\\",\\\"index\\\":\\\"111111\\\",\\\"street\\\":\\\"\\\\u043f\\\\u0440-\\\\u043a\\\\u0442 \\\\u041b\\\\u0435\\\\u043d\\\\u0438\\\\u043d\\\\u0430\\\",\\\"house\\\":\\\"60\\\\u0410\\\",\\\"housing\\\":\\\"1\\\",\\\"building\\\":\\\"2\\\",\\\"apartment\\\":\\\"3\\\",\\\"id\\\":\\\"519770\\\",\\\"comment\\\":null,\\\"city\\\":\\\"\\\\u0422\\\\u044e\\\\u043c\\\\u0435\\\\u043d\\\\u044c\\\"},\\\"full_name\\\":\\\"\\\\u0418\\\\u0432\\\\u0430\\\\u043d\\\\u043e\\\\u0432 \\\\u0421\\\\u0435\\\\u0440\\\\u0433\\\\u0435\\\\u0439\\\",\\\"phone\\\":\\\"+7(777)666-55-44\\\",\\\"raw_phone\\\":\\\"87776665544\\\",\\\"additional_phone\\\":\\\"\\\",\\\"destination_address\\\":\\\"111111, \\\\u0422\\\\u044e\\\\u043c\\\\u0435\\\\u043d\\\\u044c, \\\\u043f\\\\u0440-\\\\u043a\\\\u0442 \\\\u041b\\\\u0435\\\\u043d\\\\u0438\\\\u043d\\\\u0430, 60\\\\u0410, \\\\u0441\\\\u0442\\\\u0440. 2, \\\\u043a\\\\u043e\\\\u0440\\\\u043f. 1, \\\\u043a\\\\u0432. 3\\\",\\\"destination_address_full\\\":\\\"111111, \\\\u0422\\\\u044e\\\\u043c\\\\u0435\\\\u043d\\\\u044c, \\\\u043f\\\\u0440-\\\\u043a\\\\u0442 \\\\u041b\\\\u0435\\\\u043d\\\\u0438\\\\u043d\\\\u0430, 60\\\\u0410, \\\\u0441\\\\u0442\\\\u0440. 2, \\\\u043a\\\\u043e\\\\u0440\\\\u043f. 1, \\\\u043a\\\\u0432. 3\\\"},\\\"delivery\\\":{\\\"id\\\":\\\"28\\\",\\\"resource_id\\\":\\\"376\\\",\\\"user_id\\\":\\\"364\\\",\\\"name\\\":\\\"DPD\\\",\\\"unique_name\\\":\\\"DPD\\\",\\\"domain\\\":\\\"http:\\\\/\\\\/www.dpd.ru\\\",\\\"phone\\\":\\\"8(800) 555 45 85\\\",\\\"active\\\":\\\"1\\\",\\\"active_status\\\":\\\"3\\\",\\\"use_warehouse\\\":\\\"2\\\",\\\"created\\\":null,\\\"updated\\\":\\\"2016-03-21 08:32:23\\\",\\\"delivery_interval\\\":null,\\\"labels_size\\\":null,\\\"intake_request_email\\\":\\\"\\\",\\\"ticket_email\\\":\\\"\\\",\\\"warehouse_sort_id\\\":\\\"0\\\",\\\"last_update\\\":\\\"2016-03-21 08:32:23\\\",\\\"label_code\\\":null,\\\"yandex_delivery_id\\\":\\\"102\\\",\\\"provider_type\\\":null,\\\"limited_location_id\\\":null,\\\"time_period\\\":\\\"5\\\",\\\"contract\\\":\\\"\\\\u0414\\\\u043e\\\\u0433\\\\u043e\\\\u0432\\\\u043e\\\\u0440 10065095 \\\\u043e\\\\u0442 23.03.201\\\",\\\"documentable_id\\\":\\\"2185\\\",\\\"document_version\\\":\\\"1\\\",\\\"time_registry\\\":\\\"17:30:00\\\",\\\"method_available\\\":\\\"12\\\",\\\"is_russian_post\\\":false,\\\"is_self_delivery\\\":false,\\\"is_import_available\\\":true,\\\"is_withdraw_available\\\":true,\\\"is_only_fulfillment_method_available\\\":true,\\\"is_only_direct_method_available\\\":false},\\\"date_limits\\\":{\\\"withdraw\\\":{\\\"min\\\":\\\"2016-05-19\\\"},\\\"withdraw_sort\\\":{\\\"min\\\":\\\"2016-05-19\\\"},\\\"import\\\":{\\\"min\\\":\\\"2016-05-18\\\"},\\\"import_sort\\\":{\\\"min\\\":\\\"2016-05-18\\\"}},\\\"deliveryInterval\\\":{\\\"id\\\":\\\"508\\\",\\\"day\\\":\\\"1\\\",\\\"from\\\":\\\"09:00:00\\\",\\\"to\\\":\\\"18:00:00\\\"},\\\"order_items\\\":[{\\\"tryon\\\":0,\\\"quantity\\\":1,\\\"cost\\\":200,\\\"name\\\":\\\"\\\\u0422\\\\u043e\\\\u0432\\\\u0430\\\\u04401\\\",\\\"article\\\":\\\"abcd1\\\",\\\"weight\\\":null,\\\"length\\\":null,\\\"width\\\":null,\\\"height\\\":null,\\\"sender_order_id\\\":\\\"157337\\\",\\\"id\\\":\\\"327438\\\",\\\"sys_id\\\":null,\\\"system_id\\\":null},{\\\"tryon\\\":0,\\\"quantity\\\":5,\\\"cost\\\":200,\\\"name\\\":\\\"\\\\u0422\\\\u043e\\\\u0432\\\\u0430\\\\u04402\\\",\\\"article\\\":\\\"abcd2\\\",\\\"weight\\\":null,\\\"length\\\":null,\\\"width\\\":null,\\\"height\\\":null,\\\"sender_order_id\\\":\\\"157337\\\",\\\"id\\\":\\\"327439\\\",\\\"sys_id\\\":null,\\\"system_id\\\":null}],\\\"history\\\":[{\\\"has_changes\\\":true,\\\"when\\\":\\\"2016-05-18 03:35:09\\\",\\\"user\\\":\\\"yndx.dlvry@yandex.ru\\\",\\\"header\\\":\\\"\\\\u0418\\\\u0437\\\\u043c\\\\u0435\\\\u043d\\\\u0435\\\\u043d\\\\u0438\\\\u0435 \\\\u0441\\\\u0442\\\\u0430\\\\u0442\\\\u0443\\\\u0441\\\\u0430 \\\\u0437\\\\u0430\\\\u043a\\\\u0430\\\\u0437\\\\u0430, \\\\u0421\\\\u043e\\\\u0437\\\\u0434\\\\u0430\\\\u043d\\\\u0438\\\\u0435 \\\\u0437\\\\u0430\\\\u043f\\\\u0438\\\\u0441\\\\u0438\\\",\\\"stepItems\\\":[{\\\"has_changes\\\":true,\\\"has_deletion_event\\\":false,\\\"model_name_translated\\\":\\\"\\\\u0417\\\\u0430\\\\u043a\\\\u0430\\\\u0437\\\",\\\"changes\\\":[{\\\"is_hidden\\\":true,\\\"label\\\":\\\"\\\\u0427\\\\u0435\\\\u0440\\\\u0435\\\\u0437 \\\\u0415\\\\u0434\\\\u0438\\\\u043d\\\\u044b\\\\u0439 \\\\u0441\\\\u043a\\\\u043b\\\\u0430\\\\u0434\\\",\\\"old_val\\\":null,\\\"new_val\\\":1},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041e\\\\u043f\\\\u043b\\\\u0430\\\\u0447\\\\u0435\\\\u043d\\\\u043e \\\\u043a\\\\u043b\\\\u0438\\\\u0435\\\\u043d\\\\u0442\\\\u043e\\\\u043c\\\",\\\"old_val\\\":null,\\\"new_val\\\":1200},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"Is Manual Delivery Cost\\\",\\\"old_val\\\":null,\\\"new_val\\\":1},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0418\\\\u0442\\\\u043e\\\\u0433\\\\u043e\\\\u0432\\\\u0430\\\\u044f \\\\u0441\\\\u0442\\\\u043e\\\\u0438\\\\u043c\\\\u043e\\\\u0441\\\\u0442\\\\u044c\\\",\\\"old_val\\\":null,\\\"new_val\\\":300},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041d\\\\u043e\\\\u043c\\\\u0435\\\\u0440 \\\\u0437\\\\u0430\\\\u043a\\\\u0430\\\\u0437\\\\u0430\\\",\\\"old_val\\\":null,\\\"new_val\\\":1589123},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0412\\\\u0435\\\\u0441, \\\\u043a\\\\u0433\\\",\\\"old_val\\\":null,\\\"new_val\\\":1},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0414\\\\u043b\\\\u0438\\\\u043d\\\\u0430, \\\\u0441\\\\u043c\\\",\\\"old_val\\\":null,\\\"new_val\\\":10},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0412\\\\u044b\\\\u0441\\\\u043e\\\\u0442\\\\u0430, \\\\u0441\\\\u043c\\\",\\\"old_val\\\":null,\\\"new_val\\\":10},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0428\\\\u0438\\\\u0440\\\\u0438\\\\u043d\\\\u0430, \\\\u0441\\\\u043c\\\",\\\"old_val\\\":null,\\\"new_val\\\":10},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041e\\\\u0431\\\\u044a\\\\u044f\\\\u0432\\\\u043b\\\\u0435\\\\u043d\\\\u043d\\\\u0430\\\\u044f \\\\u0446\\\\u0435\\\\u043d\\\\u043d\\\\u043e\\\\u0441\\\\u0442\\\\u044c\\\",\\\"old_val\\\":null,\\\"new_val\\\":1200},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0420\\\\u0435\\\\u043a\\\\u0432\\\\u0438\\\\u0437\\\\u0438\\\\u0442\\\\u044b\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"\\\\u041a\\\\u042c\\\\u042e\\\\u0421\\\\u0410\\\\u0419\\\\u0411\\\\u0415\\\\u0420 \\\\u0422\\\\u0420\\\\u0415\\\\u0419\\\\u0414\\\\u0418\\\\u041d\\\\u0413\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0421\\\\u043a\\\\u043b\\\\u0430\\\\u0434\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"\\\\u0424\\\\u043e\\\\u043d\\\\u043e\\\\u041c\\\\u0430\\\\u043d\\\\u0438\\\\u044f\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041c\\\\u0430\\\\u0433\\\\u0430\\\\u0437\\\\u0438\\\\u043d\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"DesFirsT\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041a\\\\u043e\\\\u043c\\\\u043c\\\\u0435\\\\u043d\\\\u0442\\\\u0430\\\\u0440\\\\u0438\\\\u0439\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"\\\\u0414\\\\u043e\\\\u043f.\\\\u0442\\\\u0435\\\\u043b\\\\u0435\\\\u0444\\\\u043e\\\\u043d: +7(916)123-45-67\\\"},{\\\"is_hidden\\\":true,\\\"label\\\":\\\"\\\\u041f\\\\u0440\\\\u043e\\\\u0446\\\\u0435\\\\u043d\\\\u0442 \\\\u043a\\\\u0430\\\\u0441\\\\u0441\\\\u043e\\\\u0432\\\\u043e\\\\u0433\\\\u043e \\\\u0441\\\\u0431\\\\u043e\\\\u0440\\\\u0430\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"0.022000\\\"},{\\\"is_hidden\\\":true,\\\"label\\\":\\\"\\\\u041e\\\\u0440\\\\u0438\\\\u0435\\\\u043d\\\\u0442\\\\u0438\\\\u0440\\\\u043e\\\\u0432\\\\u043e\\\\u0447\\\\u043d\\\\u044b\\\\u0439 \\\\u0441\\\\u0440\\\\u043e\\\\u043a \\\\u0434\\\\u043e\\\\u0441\\\\u0442\\\\u0430\\\\u0432\\\\u0438\\\\u043a\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"3-4\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0421\\\\u043b\\\\u0443\\\\u0436\\\\u0431\\\\u0430 \\\\u0434\\\\u043e\\\\u0441\\\\u0442\\\\u0430\\\\u0432\\\\u043a\\\\u0438\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"DPD\\\"},{\\\"is_hidden\\\":true,\\\"label\\\":\\\"Tariff Id\\\",\\\"old_val\\\":null,\\\"new_val\\\":170},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0422\\\\u0438\\\\u043f \\\\u0434\\\\u043e\\\\u0441\\\\u0442\\\\u0430\\\\u0432\\\\u043a\\\\u0438\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"TODOOR\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"Delivery Interval Id\\\",\\\"old_val\\\":null,\\\"new_val\\\":508},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041f\\\\u043e\\\\u043b\\\\u0443\\\\u0447\\\\u0430\\\\u0442\\\\u0435\\\\u043b\\\\u044c\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"156770\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041f\\\\u043e\\\\u043b\\\\u044c\\\\u0437\\\\u043e\\\\u0432\\\\u0430\\\\u0442\\\\u0435\\\\u043b\\\\u044c\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"71\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"ID \\\\u0440\\\\u0435\\\\u0441\\\\u0443\\\\u0440\\\\u0441\\\\u0430\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"79\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"Documentable Id\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"180608\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"Billing Entity Id\\\",\\\"old_val\\\":null,\\\"new_val\\\":194126},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"ID\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"157337\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0421\\\\u0442\\\\u0430\\\\u0442\\\\u0443\\\\u0441\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"\\\\u0427\\\\u0435\\\\u0440\\\\u043d\\\\u043e\\\\u0432\\\\u0438\\\\u043a\\\"}]},{\\\"has_changes\\\":true,\\\"has_deletion_event\\\":false,\\\"model_name_translated\\\":\\\"\\\\u0410\\\\u0434\\\\u0440\\\\u0435\\\\u0441\\\",\\\"changes\\\":[{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0413\\\\u043e\\\\u0440\\\\u043e\\\\u0434\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"\\\\u0422\\\\u044e\\\\u043c\\\\u0435\\\\u043d\\\\u044c\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0418\\\\u043d\\\\u0434\\\\u0435\\\\u043a\\\\u0441\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"111111\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0423\\\\u043b\\\\u0438\\\\u0446\\\\u0430\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"\\\\u043f\\\\u0440-\\\\u043a\\\\u0442 \\\\u041b\\\\u0435\\\\u043d\\\\u0438\\\\u043d\\\\u0430\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0414\\\\u043e\\\\u043c\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"60\\\\u0410\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041a\\\\u043e\\\\u0440\\\\u043f\\\\u0443\\\\u0441\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"1\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0421\\\\u0442\\\\u0440\\\\u043e\\\\u0435\\\\u043d\\\\u0438\\\\u0435\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"2\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041a\\\\u0432\\\\u0430\\\\u0440\\\\u0442\\\\u0438\\\\u0440\\\\u0430\\\\\\\\\\\\u041e\\\\u0444\\\\u0438\\\\u0441\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"3\\\"}]},{\\\"has_changes\\\":true,\\\"has_deletion_event\\\":false,\\\"model_name_translated\\\":\\\"\\\\u041f\\\\u043e\\\\u043b\\\\u0443\\\\u0447\\\\u0430\\\\u0442\\\\u0435\\\\u043b\\\\u044c\\\",\\\"changes\\\":[{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0424\\\\u0430\\\\u043c\\\\u0438\\\\u043b\\\\u0438\\\\u044f\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"\\\\u0418\\\\u0432\\\\u0430\\\\u043d\\\\u043e\\\\u0432\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0418\\\\u043c\\\\u044f\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"\\\\u0421\\\\u0435\\\\u0440\\\\u0433\\\\u0435\\\\u0439\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"E-mail\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"mail@yandex.ru\\\"}]},{\\\"has_changes\\\":true,\\\"has_deletion_event\\\":false,\\\"model_name_translated\\\":\\\"\\\\u041a\\\\u043e\\\\u043d\\\\u0442\\\\u0430\\\\u043a\\\\u0442\\\\u043d\\\\u044b\\\\u0439 \\\\u0442\\\\u0435\\\\u043b\\\\u0435\\\\u0444\\\\u043e\\\\u043d\\\",\\\"changes\\\":[{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041a\\\\u043e\\\\u043d\\\\u0442\\\\u0430\\\\u043a\\\\u0442\\\\u043d\\\\u044b\\\\u0439 \\\\u0442\\\\u0435\\\\u043b\\\\u0435\\\\u0444\\\\u043e\\\\u043d\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"87776665544\\\"}]},{\\\"has_changes\\\":true,\\\"has_deletion_event\\\":false,\\\"model_name_translated\\\":\\\"\\\\u0422\\\\u043e\\\\u0432\\\\u0430\\\\u0440\\\\u043d\\\\u0430\\\\u044f \\\\u043f\\\\u043e\\\\u0437\\\\u0438\\\\u0446\\\\u0438\\\\u044f\\\",\\\"changes\\\":[{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0410\\\\u0440\\\\u0442\\\\u0438\\\\u043a\\\\u0443\\\\u043b\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"abcd1\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041d\\\\u0430\\\\u0438\\\\u043c\\\\u0435\\\\u043d\\\\u043e\\\\u0432\\\\u0430\\\\u043d\\\\u0438\\\\u0435\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"\\\\u0422\\\\u043e\\\\u0432\\\\u0430\\\\u04401\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041a\\\\u043e\\\\u043b\\\\u0438\\\\u0447\\\\u0435\\\\u0441\\\\u0442\\\\u0432\\\\u043e\\\",\\\"old_val\\\":null,\\\"new_val\\\":1},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0421\\\\u0442\\\\u043e\\\\u0438\\\\u043c\\\\u043e\\\\u0441\\\\u0442\\\\u044c\\\",\\\"old_val\\\":null,\\\"new_val\\\":200}]},{\\\"has_changes\\\":true,\\\"has_deletion_event\\\":false,\\\"model_name_translated\\\":\\\"\\\\u0422\\\\u043e\\\\u0432\\\\u0430\\\\u0440\\\\u043d\\\\u0430\\\\u044f \\\\u043f\\\\u043e\\\\u0437\\\\u0438\\\\u0446\\\\u0438\\\\u044f\\\",\\\"changes\\\":[{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0410\\\\u0440\\\\u0442\\\\u0438\\\\u043a\\\\u0443\\\\u043b\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"abcd2\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041d\\\\u0430\\\\u0438\\\\u043c\\\\u0435\\\\u043d\\\\u043e\\\\u0432\\\\u0430\\\\u043d\\\\u0438\\\\u0435\\\",\\\"old_val\\\":null,\\\"new_val\\\":\\\"\\\\u0422\\\\u043e\\\\u0432\\\\u0430\\\\u04402\\\"},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u041a\\\\u043e\\\\u043b\\\\u0438\\\\u0447\\\\u0435\\\\u0441\\\\u0442\\\\u0432\\\\u043e\\\",\\\"old_val\\\":null,\\\"new_val\\\":5},{\\\"is_hidden\\\":false,\\\"label\\\":\\\"\\\\u0421\\\\u0442\\\\u043e\\\\u0438\\\\u043c\\\\u043e\\\\u0441\\\\u0442\\\\u044c\\\",\\\"old_val\\\":null,\\\"new_val\\\":200}]}]}],\\\"charges\\\":[{\\\"id\\\":\\\"666730\\\",\\\"billing_entity_id\\\":\\\"194126\\\",\\\"service_id\\\":null,\\\"type\\\":\\\"DELIVERY\\\",\\\"amount\\\":\\\"300.00\\\",\\\"charge_from\\\":\\\"RECIPIENT\\\",\\\"fact\\\":\\\"0\\\",\\\"created\\\":\\\"2016-05-18 03:35:09\\\",\\\"updated\\\":null,\\\"service\\\":[]},{\\\"id\\\":\\\"666731\\\",\\\"billing_entity_id\\\":\\\"194126\\\",\\\"service_id\\\":null,\\\"type\\\":\\\"DELIVERY\\\",\\\"amount\\\":\\\"401.00\\\",\\\"charge_from\\\":\\\"SENDER\\\",\\\"fact\\\":\\\"0\\\",\\\"created\\\":\\\"2016-05-18 03:35:09\\\",\\\"updated\\\":null,\\\"service\\\":[]},{\\\"id\\\":\\\"666733\\\",\\\"billing_entity_id\\\":\\\"194126\\\",\\\"service_id\\\":\\\"1\\\",\\\"type\\\":\\\"CASH_COMISSION\\\",\\\"amount\\\":\\\"30.00\\\",\\\"charge_from\\\":\\\"SENDER\\\",\\\"fact\\\":\\\"0\\\",\\\"created\\\":\\\"2016-05-18 03:35:09\\\",\\\"updated\\\":null,\\\"service\\\":{\\\"id\\\":\\\"1\\\",\\\"name\\\":\\\"\\\\u0412\\\\u043e\\\\u0437\\\\u043d\\\\u0430\\\\u0433\\\\u0440\\\\u0430\\\\u0436\\\\u0434\\\\u0435\\\\u043d\\\\u0438\\\\u0435 \\\\u0437\\\\u0430 \\\\u043f\\\\u0435\\\\u0440\\\\u0435\\\\u0447\\\\u0438\\\\u0441\\\\u043b\\\\u0435\\\\u043d\\\\u0438\\\\u0435 \\\\u0434\\\\u0435\\\\u043d\\\\u0435\\\\u0436\\\\u043d\\\\u044b\\\\u0445 \\\\u0441\\\\u0440\\\\u0435\\\\u0434\\\\u0441\\\\u0442\\\\u0432\\\",\\\"code\\\":\\\"CASH_SERVICE\\\",\\\"description\\\":null,\\\"is_optional\\\":\\\"0\\\",\\\"active\\\":\\\"0\\\"}},{\\\"id\\\":\\\"666734\\\",\\\"billing_entity_id\\\":\\\"194126\\\",\\\"service_id\\\":\\\"3\\\",\\\"type\\\":\\\"SERVICE\\\",\\\"amount\\\":\\\"5.66\\\",\\\"charge_from\\\":\\\"SENDER\\\",\\\"fact\\\":\\\"0\\\",\\\"created\\\":\\\"2016-05-18 03:35:09\\\",\\\"updated\\\":null,\\\"service\\\":{\\\"id\\\":\\\"3\\\",\\\"name\\\":\\\"\\\\u041f\\\\u0440\\\\u043e\\\\u0446\\\\u0435\\\\u043d\\\\u0442 \\\\u0437\\\\u0430 \\\\u043e\\\\u0431\\\\u044a\\\\u044f\\\\u0432\\\\u043b\\\\u0435\\\\u043d\\\\u043d\\\\u0443\\\\u044e \\\\u0446\\\\u0435\\\\u043d\\\\u043d\\\\u043e\\\\u0441\\\\u0442\\\\u044c\\\",\\\"code\\\":\\\"INSURANCE\\\",\\\"description\\\":null,\\\"is_optional\\\":\\\"0\\\",\\\"active\\\":\\\"0\\\"}},{\\\"id\\\":\\\"666732\\\",\\\"billing_entity_id\\\":\\\"194126\\\",\\\"service_id\\\":\\\"6\\\",\\\"type\\\":\\\"SERVICE\\\",\\\"amount\\\":\\\"25.00\\\",\\\"charge_from\\\":\\\"SENDER\\\",\\\"fact\\\":\\\"0\\\",\\\"created\\\":\\\"2016-05-18 03:35:09\\\",\\\"updated\\\":null,\\\"service\\\":{\\\"id\\\":\\\"6\\\",\\\"name\\\":\\\"\\\\u0421\\\\u043e\\\\u0440\\\\u0442\\\\u0438\\\\u0440\\\\u043e\\\\u0432\\\\u043a\\\\u0430 \\\\u043d\\\\u0430 \\\\u0435\\\\u0434\\\\u0438\\\\u043d\\\\u043e\\\\u043c \\\\u0441\\\\u043a\\\\u043b\\\\u0430\\\\u0434\\\\u0435\\\",\\\"code\\\":\\\"SORT\\\",\\\"description\\\":null,\\\"is_optional\\\":\\\"0\\\",\\\"active\\\":\\\"0\\\"}}],\\\"offer\\\":{\\\"cost\\\":300,\\\"costWithRules\\\":300,\\\"services\\\":[{\\\"name\\\":\\\"\\\\u0412\\\\u043e\\\\u0437\\\\u043d\\\\u0430\\\\u0433\\\\u0440\\\\u0430\\\\u0436\\\\u0434\\\\u0435\\\\u043d\\\\u0438\\\\u0435 \\\\u0437\\\\u0430 \\\\u043f\\\\u0435\\\\u0440\\\\u0435\\\\u0447\\\\u0438\\\\u0441\\\\u043b\\\\u0435\\\\u043d\\\\u0438\\\\u0435 \\\\u0434\\\\u0435\\\\u043d\\\\u0435\\\\u0436\\\\u043d\\\\u044b\\\\u0445 \\\\u0441\\\\u0440\\\\u0435\\\\u0434\\\\u0441\\\\u0442\\\\u0432\\\",\\\"cost\\\":\\\"30.00\\\"},{\\\"name\\\":\\\"\\\\u041f\\\\u0440\\\\u043e\\\\u0446\\\\u0435\\\\u043d\\\\u0442 \\\\u0437\\\\u0430 \\\\u043e\\\\u0431\\\\u044a\\\\u044f\\\\u0432\\\\u043b\\\\u0435\\\\u043d\\\\u043d\\\\u0443\\\\u044e \\\\u0446\\\\u0435\\\\u043d\\\\u043d\\\\u043e\\\\u0441\\\\u0442\\\\u044c\\\",\\\"cost\\\":\\\"5.66\\\"},{\\\"name\\\":\\\"\\\\u0421\\\\u043e\\\\u0440\\\\u0442\\\\u0438\\\\u0440\\\\u043e\\\\u0432\\\\u043a\\\\u0430 \\\\u043d\\\\u0430 \\\\u0435\\\\u0434\\\\u0438\\\\u043d\\\\u043e\\\\u043c \\\\u0441\\\\u043a\\\\u043b\\\\u0430\\\\u0434\\\\u0435\\\",\\\"cost\\\":\\\"25.00\\\"}]},\\\"is_editable\\\":true,\\\"is_draft\\\":true,\\\"is_failure\\\":false}}}\\\";\",\"resourceId\":\"79\",\"userId\":\"71\",\"hostname\":\"web\",\"applicationId\":\"2e0ca606820caa79b9b82c6a49f6e0ce6954e79376dbf7cdaa845e64c469c04a\"}",
            new Date(1463531718000L),
            new String[]{"OpenApi"},
            "createorder",
            "ok",
            "",
            "79",
            "3",
            200,
            24136544
        );
        checker.check(
            "[2016-05-18 19:01:37] OpenApi:INFO:updateorder: REQUEST [] {\"memoryPeakUsage\":\"8437584\",\"httpCode\":\"200\",\"executionTime\":\"00:00:01\",\"request\":\"{\\\"client_id\\\":\\\"79\\\",\\\"sender_id\\\":\\\"3s\\\",\\\"order_num\\\":\\\"1589123\\\",\\\"recipient_first_name\\\":\\\"\\\\u0421\\\\u0435\\\\u0440\\\\u0433\\\\u0435\\\\u0439\\\",\\\"recipient_last_name\\\":\\\"\\\\u0418\\\\u0432\\\\u0430\\\\u043d\\\\u043e\\\\u0432\\\",\\\"recipient_phone\\\":\\\"87776665544\\\",\\\"recipient_email\\\":\\\"mail@yandex.ru\\\",\\\"order_comment\\\":\\\"\\\\u0414\\\\u043e\\\\u043f.\\\\u0442\\\\u0435\\\\u043b\\\\u0435\\\\u0444\\\\u043e\\\\u043d: +7(916)123-45-67\\\",\\\"order_weight\\\":\\\"1\\\",\\\"order_length\\\":\\\"10\\\",\\\"order_width\\\":\\\"10\\\",\\\"order_height\\\":\\\"10\\\",\\\"order_requisite\\\":\\\"42\\\",\\\"order_warehouse\\\":\\\"63\\\",\\\"order_payment_method\\\":\\\"3\\\",\\\"order_assessed_value\\\":\\\"1200\\\",\\\"order_amount_prepaid\\\":\\\"1200\\\",\\\"order_delivery_cost\\\":\\\"300\\\",\\\"is_manual_delivery_cost\\\":\\\"1\\\",\\\"deliverypoint_city\\\":\\\"\\\\u0422\\\\u044e\\\\u043c\\\\u0435\\\\u043d\\\\u044c\\\",\\\"deliverypoint_street\\\":\\\"\\\\u043f\\\\u0440-\\\\u043a\\\\u0442 \\\\u041b\\\\u0435\\\\u043d\\\\u0438\\\\u043d\\\\u0430\\\",\\\"deliverypoint_house\\\":\\\"60\\\\u0410\\\",\\\"deliverypoint_housing\\\":\\\"1\\\",\\\"deliverypoint_build\\\":\\\"2\\\",\\\"deliverypoint_flat\\\":\\\"3\\\",\\\"deliverypoint_index\\\":\\\"111111\\\",\\\"delivery_delivery\\\":\\\"28\\\",\\\"delivery_direction\\\":\\\"714\\\",\\\"delivery_tariff\\\":\\\"170\\\",\\\"delivery_pickuppoint\\\":\\\"\\\",\\\"delivery_to_yd_warehouse\\\":\\\"1\\\",\\\"order_items\\\":[{\\\"orderitem_article\\\":\\\"abcd1\\\",\\\"orderitem_name\\\":\\\"\\\\u0422\\\\u043e\\\\u0432\\\\u0430\\\\u04401\\\",\\\"orderitem_quantity\\\":\\\"1\\\",\\\"orderitem_cost\\\":\\\"200\\\"},{\\\"orderitem_article\\\":\\\"abcd2\\\",\\\"orderitem_name\\\":\\\"\\\\u0422\\\\u043e\\\\u0432\\\\u0430\\\\u04402\\\",\\\"orderitem_quantity\\\":\\\"5\\\",\\\"orderitem_cost\\\":\\\"200\\\"}],\\\"secret_key\\\":\\\"e9cb87b0033a6d19077dc3e46edad407\\\"}\",\"response\":\"s:242:\\\"{\\\"status\\\":\\\"error\\\",\\\"data\\\":{\\\"errors\\\":{\\\"hashValid\\\":\\\"\\\\u0417\\\\u043d\\\\u0430\\\\u0447\\\\u0435\\\\u043d\\\\u0438\\\\u0435 \\\\u0434\\\\u043e\\\\u043b\\\\u0436\\\\u043d\\\\u043e \\\\u0431\\\\u044b\\\\u0442\\\\u044c \\\\u0438\\\\u0441\\\\u0442\\\\u0438\\\\u043d\\\\u043d\\\\u044b\\\\u043c.\\\"}},\\\"error\\\":\\\"ERROR_WRONG_PARAMS\\\"}\\\";\",\"resourceId\":\"0\",\"userId\":\"0\",\"hostname\":\"web\",\"applicationId\":\"028b1a2a66e82d7d4fcd72e1ea5464237acf6e517fe1c2fcfcfedabca7b31659\"}",
            new Date(1463587297000L),
            new String[]{"OpenApi"},
            "updateorder",
            "error",
            "ERROR_WRONG_PARAMS",
            "79",
            "3s",
            200,
            8437584
        );
        checker.check(
            "[2016-05-18 16:53:58] OpenApi:INFO:deleteorder: REQUEST [] {\"memoryPeakUsage\":\"4430240\",\"httpCode\":\"404\",\"executionTime\":\"00:00:01\",\"request\":\"[]\",\"resourceId\":\"0\",\"userId\":\"0\",\"hostname\":\"web\",\"applicationId\":\"b48cabf88111b56f853bc783693b1f26cee5e24d8f83355abfde6db50ea27f63\"}",
            new Date(1463579638000L),
            new String[]{"OpenApi"},
            "deleteorder",
            "",
            "",
            "",
            "",
            404,
            4430240
        );
    }
}
