package ru.yandex.market.logshatter.parser.front;

import org.junit.Before;
import org.junit.Test;
import ru.yandex.market.logshatter.parser.LogParserChecker;

import java.util.Date;

/**
 * Created by saferif on 22.09.15.
 *
 * @author Insaf Latypov <a href="mailto:saferif@yandex-team.ru"></a>
 */
public class XScriptErrorLogParserTest {

    private LogParserChecker checker;

    @Before
    public void setUp() {
        checker = new LogParserChecker(new XScriptErrorLogParser());
    }

    @Test
    public void testParseCorba() throws Exception {
        String lineSyslog = "[2015/08/18 10:53:21] warning: bugaga : critical 195.91.253.98 : xscript_invoke_failed=CORBA exception block getCommentsBulk  Yandex/CommentStorage.id https://partner.market.yandex.ru/shop-opinions.xml?id=21232854&shop_id=1818&grade_value=2 : /page/content/grade-comments/xscript_invoke_failed[comment-storage:getCommentsBulk] prev: parent:/page/content/grade-comments uid:302271211";
        String lineFile = "[2015/08/18 10:53:21] warn: bugaga : critical 195.91.253.98 : xscript_invoke_failed=CORBA exception block getCommentsBulk  Yandex/CommentStorage.id https://partner.market.yandex.ru/shop-opinions.xml?id=21232854&shop_id=1818&grade_value=2 : /page/content/grade-comments/xscript_invoke_failed[comment-storage:getCommentsBulk] prev: parent:/page/content/grade-comments uid:302271211";

        checker.check(
            lineSyslog,
            new Date(1439884401000L), "hostname.test", "partner.market.yandex.ru", "critical", "195.91.253.98", "xscript_invoke_failed=CORBA exception block getCommentsBulk  Yandex/CommentStorage.id ", "/shop-opinions.xml", "id=21232854&shop_id=1818&grade_value=2", "/page/content/grade-comments/xscript_invoke_failed[comment-storage:getCommentsBulk]", "302271211", ""
        );
        checker.check(
            lineFile,
            new Date(1439884401000L), "hostname.test", "partner.market.yandex.ru", "critical", "195.91.253.98", "xscript_invoke_failed=CORBA exception block getCommentsBulk  Yandex/CommentStorage.id ", "/shop-opinions.xml", "id=21232854&shop_id=1818&grade_value=2", "/page/content/grade-comments/xscript_invoke_failed[comment-storage:getCommentsBulk]", "302271211", ""
        );
    }

    @Test
    public void testParseHttp() throws Exception {
        String lineSyslog = "[2015/08/18 11:42:09] warning: bugaga : log 107.15.77.16 : xscript_invoke_failed=server responded 403 http getHttp http://marketpaymentsvnt.yandex.ru:38271/logPartnerVisit?_user_id=303708927&_remote_ip=107.15.77.16 https://partner.market.yandex.ru/pre/ : /page/settings/log-partner-visit/xscript_invoke_failed[mbi-payment:getHttp:logPartnerVisit] prev: parent:/page/settings/log-partner-visit uid:303708927";
        String lineFile = "[2015/08/18 11:42:09] warn: bugaga : log 107.15.77.16 : xscript_invoke_failed=server responded 403 http getHttp http://marketpaymentsvnt.yandex.ru:38271/logPartnerVisit?_user_id=303708927&_remote_ip=107.15.77.16 https://partner.market.yandex.ru/pre/ : /page/settings/log-partner-visit/xscript_invoke_failed[mbi-payment:getHttp:logPartnerVisit] prev: parent:/page/settings/log-partner-visit uid:303708927";

        checker.check(
            lineSyslog,
            new Date(1439887329000L), "hostname.test", "partner.market.yandex.ru", "log", "107.15.77.16", "xscript_invoke_failed=server responded 403 http getHttp http://marketpaymentsvnt.yandex.ru:38271/logPartnerVisit?_user_id=303708927&_remote_ip=107.15.77.16 ", "/pre/", "", "/page/settings/log-partner-visit/xscript_invoke_failed[mbi-payment:getHttp:logPartnerVisit]", "303708927", ""
        );
        checker.check(
            lineFile,
            new Date(1439887329000L), "hostname.test", "partner.market.yandex.ru", "log", "107.15.77.16", "xscript_invoke_failed=server responded 403 http getHttp http://marketpaymentsvnt.yandex.ru:38271/logPartnerVisit?_user_id=303708927&_remote_ip=107.15.77.16 ", "/pre/", "", "/page/settings/log-partner-visit/xscript_invoke_failed[mbi-payment:getHttp:logPartnerVisit]", "303708927", ""
        );
    }

    @Test
    public void testParseStackTrace() throws Exception {
        String lineSyslog = "[2016/01/18 15:49:27] warning: bugaga : critical 62.4.55.133 : <system-error><name>UncategorizedSQLException</name><message>PreparedStatementCallback; uncategorized SQLException for SQL [select rowid, eventtime, trantime, shop_id, url, request, args, success, sandbox, user_id,  | request_headers, request_body, response_headers, response_body,  | response_error, response_sub_error, error_description, host, response_time | from shops_web.pushapi_log where eventtime >= ? and eventtime < ?  and shop_id = ? and ( (sandbox = ?) ) order by eventtime DESC]; SQL state [60000]; error code [600]; ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | ; nested exception is java.sql.SQLException: ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | </message><cause>org.springframework.jdbc.UncategorizedSQLException: PreparedStatementCallback; uncategorized SQLException for SQL [select rowid, eventtime, trantime, shop_id, url, request, args, success, sandbox, user_id,  | request_headers, request_body, response_headers, response_body,  | response_error, response_sub_error, error_description, host, response_time | from shops_web.pushapi_log where eventtime >= ? and eventtime < ?  and shop_id = ? and ( (sandbox = ?) ) order by eventtime DESC]; SQL state [60000]; error code [600]; ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | ; nested exception is java.sql.SQLException: ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | </cause><details>org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:83) | org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:80) | org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:80) | ru.yandex.market.core.util.spring.LoggingSQLErrorCodeSQLExceptionTranslator.translate(LoggingSQLErrorCodeSQLExceptionTranslator.java:26) | org.springframework.jdbc.core.JdbcTemplate.execute(JdbcTemplate.java:605) | org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:639) | org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:668) | org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:676) | ru.yandex.market.api.DbLogReaderService.getRecords(DbLogReaderService.java:25) | ru.yandex.market.partner.api.cpa.ViewCpaApiLogServantlet.processWithParams(ViewCpaApiLogServantlet.java:46) | ru.yandex.market.core.servantlet.AutoParamServantlet.process(AutoParamServantlet.java:36) | sun.reflect.GeneratedMethodAccessor29.invoke(Unknown Source) | sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) | java.lang.reflect.Method.invoke(Method.java:497) | org.springframework.aop.support.AopUtils.invokeJoinpointUsingReflection(AopUtils.java:317) | org.springframework.aop.framework.ReflectiveMethodInvocation.invokeJoinpoint(ReflectiveMethodInvocation.java:183) | org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:150) | org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint.proceed(MethodInvocationProceedingJoinPoint.java:80) | ru.yandex.market.partner.PartnerErrorHandlingAspect.handleErrors(PartnerErrorHandlingAspect.java:35) | sun.reflect.GeneratedMethodAccessor28.invoke(Unknown Source) | sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) | java.lang.reflect.Method.invoke(Method.java:497) | org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethodWithGivenArgs(AbstractAspectJAdvice.java:621) | org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethod(AbstractAspectJAdvice.java:610) | org.springframework.aop.aspectj.AspectJAroundAdvice.invoke(AspectJAroundAdvice.java:65) | org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) | org.springframework.aop.interceptor.ExposeInvocationInterceptor.invoke(ExposeInvocationInterceptor.java:91) | org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) | org.springframework.aop.framework.JdkDynamicAopProxy.invoke(JdkDynamicAopProxy.java:204) | com.sun.proxy.$Proxy65.process(Unknown Source) | ru.yandex.market.core.framework.context.InContextServantletDispatcher$ServantletWrapper.process(InContextServantletDispatcher.java:53) | ru.yandex.common.framework.core.ServantletManager.processRequest(ServantletManager.java:102) | ru.yandex.common.framework.core.ServantletManager.processCheckAccess(ServantletManager.java:127) | ru.yandex.common.framework.core.ServantletManager.processSingle(ServantletManager.java:176) | ru.yandex.common.framework.http.DefaultRequestHandler.handle(DefaultRequestHandler.java:130) | ru.yandex.market.partner.corba.servant.PartnerDefaultRequestHandler.handle(PartnerDefaultRequestHandler.java:44) | org.mortbay.jetty.handler.HandlerCollection.handle(HandlerCollection.java:114) | org.mortbay.jetty.handler.HandlerWrapper.handle(HandlerWrapper.java:152) | org.mortbay.jetty.Server.handle(Server.java:326) | org.mortbay.jetty.HttpConnection.handleRequest(HttpConnection.java:542) | org.mortbay.jetty.HttpConnection$RequestHandler.headerComplete(HttpConnection.java:928) | org.mortbay.jetty.HttpParser.parseNext(HttpParser.java:549) | org.mortbay.jetty.HttpParser.parseAvailable(HttpParser.java:212) | org.mortbay.jetty.HttpConnection.handle(HttpConnection.java:404) | org.mortbay.io.nio.SelectChannelEndPoint.run(SelectChannelEndPoint.java:410) | org.mortbay.thread.QueuedThreadPool$PoolThread.run(QueuedThreadPool.java:582) | </details><error-code>22DE8702E</error-code></system-error> https://partner.market.yandex.ru/sandbox/api-log.xml?id=21165597&sort=date&order=desc&pageSize=50&sandbox=1&fdt=01.01.2015+00%3A00%3A00&tdt=28.02.2015+23%3A59%3A59&body= : /page/content/data[actions=viewCpaApiLog]/errors/system-error prev: parent:/page/content/data[actions=viewCpaApiLog]/errors uid:317455807";
        String lineFile = "[2016/01/18 15:49:27] warn: bugaga : critical 62.4.55.133 : <system-error><name>UncategorizedSQLException</name><message>PreparedStatementCallback; uncategorized SQLException for SQL [select rowid, eventtime, trantime, shop_id, url, request, args, success, sandbox, user_id,  | request_headers, request_body, response_headers, response_body,  | response_error, response_sub_error, error_description, host, response_time | from shops_web.pushapi_log where eventtime >= ? and eventtime < ?  and shop_id = ? and ( (sandbox = ?) ) order by eventtime DESC]; SQL state [60000]; error code [600]; ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | ; nested exception is java.sql.SQLException: ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | </message><cause>org.springframework.jdbc.UncategorizedSQLException: PreparedStatementCallback; uncategorized SQLException for SQL [select rowid, eventtime, trantime, shop_id, url, request, args, success, sandbox, user_id,  | request_headers, request_body, response_headers, response_body,  | response_error, response_sub_error, error_description, host, response_time | from shops_web.pushapi_log where eventtime >= ? and eventtime < ?  and shop_id = ? and ( (sandbox = ?) ) order by eventtime DESC]; SQL state [60000]; error code [600]; ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | ; nested exception is java.sql.SQLException: ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | </cause><details>org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:83) | org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:80) | org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:80) | ru.yandex.market.core.util.spring.LoggingSQLErrorCodeSQLExceptionTranslator.translate(LoggingSQLErrorCodeSQLExceptionTranslator.java:26) | org.springframework.jdbc.core.JdbcTemplate.execute(JdbcTemplate.java:605) | org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:639) | org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:668) | org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:676) | ru.yandex.market.api.DbLogReaderService.getRecords(DbLogReaderService.java:25) | ru.yandex.market.partner.api.cpa.ViewCpaApiLogServantlet.processWithParams(ViewCpaApiLogServantlet.java:46) | ru.yandex.market.core.servantlet.AutoParamServantlet.process(AutoParamServantlet.java:36) | sun.reflect.GeneratedMethodAccessor29.invoke(Unknown Source) | sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) | java.lang.reflect.Method.invoke(Method.java:497) | org.springframework.aop.support.AopUtils.invokeJoinpointUsingReflection(AopUtils.java:317) | org.springframework.aop.framework.ReflectiveMethodInvocation.invokeJoinpoint(ReflectiveMethodInvocation.java:183) | org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:150) | org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint.proceed(MethodInvocationProceedingJoinPoint.java:80) | ru.yandex.market.partner.PartnerErrorHandlingAspect.handleErrors(PartnerErrorHandlingAspect.java:35) | sun.reflect.GeneratedMethodAccessor28.invoke(Unknown Source) | sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) | java.lang.reflect.Method.invoke(Method.java:497) | org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethodWithGivenArgs(AbstractAspectJAdvice.java:621) | org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethod(AbstractAspectJAdvice.java:610) | org.springframework.aop.aspectj.AspectJAroundAdvice.invoke(AspectJAroundAdvice.java:65) | org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) | org.springframework.aop.interceptor.ExposeInvocationInterceptor.invoke(ExposeInvocationInterceptor.java:91) | org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) | org.springframework.aop.framework.JdkDynamicAopProxy.invoke(JdkDynamicAopProxy.java:204) | com.sun.proxy.$Proxy65.process(Unknown Source) | ru.yandex.market.core.framework.context.InContextServantletDispatcher$ServantletWrapper.process(InContextServantletDispatcher.java:53) | ru.yandex.common.framework.core.ServantletManager.processRequest(ServantletManager.java:102) | ru.yandex.common.framework.core.ServantletManager.processCheckAccess(ServantletManager.java:127) | ru.yandex.common.framework.core.ServantletManager.processSingle(ServantletManager.java:176) | ru.yandex.common.framework.http.DefaultRequestHandler.handle(DefaultRequestHandler.java:130) | ru.yandex.market.partner.corba.servant.PartnerDefaultRequestHandler.handle(PartnerDefaultRequestHandler.java:44) | org.mortbay.jetty.handler.HandlerCollection.handle(HandlerCollection.java:114) | org.mortbay.jetty.handler.HandlerWrapper.handle(HandlerWrapper.java:152) | org.mortbay.jetty.Server.handle(Server.java:326) | org.mortbay.jetty.HttpConnection.handleRequest(HttpConnection.java:542) | org.mortbay.jetty.HttpConnection$RequestHandler.headerComplete(HttpConnection.java:928) | org.mortbay.jetty.HttpParser.parseNext(HttpParser.java:549) | org.mortbay.jetty.HttpParser.parseAvailable(HttpParser.java:212) | org.mortbay.jetty.HttpConnection.handle(HttpConnection.java:404) | org.mortbay.io.nio.SelectChannelEndPoint.run(SelectChannelEndPoint.java:410) | org.mortbay.thread.QueuedThreadPool$PoolThread.run(QueuedThreadPool.java:582) | </details><error-code>22DE8702E</error-code></system-error> https://partner.market.yandex.ru/sandbox/api-log.xml?id=21165597&sort=date&order=desc&pageSize=50&sandbox=1&fdt=01.01.2015+00%3A00%3A00&tdt=28.02.2015+23%3A59%3A59&body= : /page/content/data[actions=viewCpaApiLog]/errors/system-error prev: parent:/page/content/data[actions=viewCpaApiLog]/errors uid:317455807";

        checker.check(
            lineSyslog,
            new Date(1453121367000L), "hostname.test", "partner.market.yandex.ru", "critical", "62.4.55.133", "<system-error><name>UncategorizedSQLException</name><message>PreparedStatementCallback; uncategorized SQLException for SQL [select rowid, eventtime, trantime, shop_id, url, request, args, success, sandbox, user_id,  | request_headers, request_body, response_headers, response_body,  | response_error, response_sub_error, error_description, host, response_time | from shops_web.pushapi_log where eventtime >= ? and eventtime < ?  and shop_id = ? and ( (sandbox = ?) ) order by eventtime DESC]; SQL state [60000]; error code [600]; ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | ; nested exception is java.sql.SQLException: ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | </message><cause>org.springframework.jdbc.UncategorizedSQLException: PreparedStatementCallback; uncategorized SQLException for SQL [select rowid, eventtime, trantime, shop_id, url, request, args, success, sandbox, user_id,  | request_headers, request_body, response_headers, response_body,  | response_error, response_sub_error, error_description, host, response_time | from shops_web.pushapi_log where eventtime >= ? and eventtime < ?  and shop_id = ? and ( (sandbox = ?) ) order by eventtime DESC]; SQL state [60000]; error code [600]; ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | ; nested exception is java.sql.SQLException: ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | </cause><details>org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:83) | org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:80) | org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:80) | ru.yandex.market.core.util.spring.LoggingSQLErrorCodeSQLExceptionTranslator.translate(LoggingSQLErrorCodeSQLExceptionTranslator.java:26) | org.springframework.jdbc.core.JdbcTemplate.execute(JdbcTemplate.java:605) | org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:639) | org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:668) | org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:676) | ru.yandex.market.api.DbLogReaderService.getRecords(DbLogReaderService.java:25) | ru.yandex.market.partner.api.cpa.ViewCpaApiLogServantlet.processWithParams(ViewCpaApiLogServantlet.java:46) | ru.yandex.market.core.servantlet.AutoParamServantlet.process(AutoParamServantlet.java:36) | sun.reflect.GeneratedMethodAccessor29.invoke(Unknown Source) | sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) | java.lang.reflect.Method.invoke(Method.java:497) | org.springframework.aop.support.AopUtils.invokeJoinpointUsingReflection(AopUtils.java:317) | org.springframework.aop.framework.ReflectiveMethodInvocation.invokeJoinpoint(ReflectiveMethodInvocation.java:183) | org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:150) | org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint.proceed(MethodInvocationProceedingJoinPoint.java:80) | ru.yandex.market.partner.PartnerErrorHandlingAspect.handleErrors(PartnerErrorHandlingAspect.java:35) | sun.reflect.GeneratedMethodAccessor28.invoke(Unknown Source) | sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) | java.lang.reflect.Method.invoke(Method.java:497) | org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethodWithGivenArgs(AbstractAspectJAdvice.java:621) | org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethod(AbstractAspectJAdvice.java:610) | org.springframework.aop.aspectj.AspectJAroundAdvice.invoke(AspectJAroundAdvice.java:65) | org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) | org.springframework.aop.interceptor.ExposeInvocationInterceptor.invoke(ExposeInvocationInterceptor.java:91) | org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) | org.springframework.aop.framework.JdkDynamicAopProxy.invoke(JdkDynamicAopProxy.java:204) | com.sun.proxy.$Proxy65.process(Unknown Source) | ru.yandex.market.core.framework.context.InContextServantletDispatcher$ServantletWrapper.process(InContextServantletDispatcher.java:53) | ru.yandex.common.framework.core.ServantletManager.processRequest(ServantletManager.java:102) | ru.yandex.common.framework.core.ServantletManager.processCheckAccess(ServantletManager.java:127) | ru.yandex.common.framework.core.ServantletManager.processSingle(ServantletManager.java:176) | ru.yandex.common.framework.http.DefaultRequestHandler.handle(DefaultRequestHandler.java:130) | ru.yandex.market.partner.corba.servant.PartnerDefaultRequestHandler.handle(PartnerDefaultRequestHandler.java:44) | org.mortbay.jetty.handler.HandlerCollection.handle(HandlerCollection.java:114) | org.mortbay.jetty.handler.HandlerWrapper.handle(HandlerWrapper.java:152) | org.mortbay.jetty.Server.handle(Server.java:326) | org.mortbay.jetty.HttpConnection.handleRequest(HttpConnection.java:542) | org.mortbay.jetty.HttpConnection$RequestHandler.headerComplete(HttpConnection.java:928) | org.mortbay.jetty.HttpParser.parseNext(HttpParser.java:549) | org.mortbay.jetty.HttpParser.parseAvailable(HttpParser.java:212) | org.mortbay.jetty.HttpConnection.handle(HttpConnection.java:404) | org.mortbay.io.nio.SelectChannelEndPoint.run(SelectChannelEndPoint.java:410) | org.mortbay.thread.QueuedThreadPool$PoolThread.run(QueuedThreadPool.java:582) | </details><error-code>22DE8702E</error-code></system-error> ",
            "/sandbox/api-log.xml", "id=21165597&sort=date&order=desc&pageSize=50&sandbox=1&fdt=01.01.2015+00%3A00%3A00&tdt=28.02.2015+23%3A59%3A59&body=", "/page/content/data[actions=viewCpaApiLog]/errors/system-error", "317455807", ""
        );
        checker.check(
            lineFile,
            new Date(1453121367000L), "hostname.test", "partner.market.yandex.ru", "critical", "62.4.55.133", "<system-error><name>UncategorizedSQLException</name><message>PreparedStatementCallback; uncategorized SQLException for SQL [select rowid, eventtime, trantime, shop_id, url, request, args, success, sandbox, user_id,  | request_headers, request_body, response_headers, response_body,  | response_error, response_sub_error, error_description, host, response_time | from shops_web.pushapi_log where eventtime >= ? and eventtime < ?  and shop_id = ? and ( (sandbox = ?) ) order by eventtime DESC]; SQL state [60000]; error code [600]; ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | ; nested exception is java.sql.SQLException: ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | </message><cause>org.springframework.jdbc.UncategorizedSQLException: PreparedStatementCallback; uncategorized SQLException for SQL [select rowid, eventtime, trantime, shop_id, url, request, args, success, sandbox, user_id,  | request_headers, request_body, response_headers, response_body,  | response_error, response_sub_error, error_description, host, response_time | from shops_web.pushapi_log where eventtime >= ? and eventtime < ?  and shop_id = ? and ( (sandbox = ?) ) order by eventtime DESC]; SQL state [60000]; error code [600]; ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | ; nested exception is java.sql.SQLException: ORA-00600: internal error code, arguments: [kksgaItLvl_Setup: desc], [3], [3], [], [], [], [], [], [], [], [], [] | </cause><details>org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:83) | org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:80) | org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:80) | ru.yandex.market.core.util.spring.LoggingSQLErrorCodeSQLExceptionTranslator.translate(LoggingSQLErrorCodeSQLExceptionTranslator.java:26) | org.springframework.jdbc.core.JdbcTemplate.execute(JdbcTemplate.java:605) | org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:639) | org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:668) | org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:676) | ru.yandex.market.api.DbLogReaderService.getRecords(DbLogReaderService.java:25) | ru.yandex.market.partner.api.cpa.ViewCpaApiLogServantlet.processWithParams(ViewCpaApiLogServantlet.java:46) | ru.yandex.market.core.servantlet.AutoParamServantlet.process(AutoParamServantlet.java:36) | sun.reflect.GeneratedMethodAccessor29.invoke(Unknown Source) | sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) | java.lang.reflect.Method.invoke(Method.java:497) | org.springframework.aop.support.AopUtils.invokeJoinpointUsingReflection(AopUtils.java:317) | org.springframework.aop.framework.ReflectiveMethodInvocation.invokeJoinpoint(ReflectiveMethodInvocation.java:183) | org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:150) | org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint.proceed(MethodInvocationProceedingJoinPoint.java:80) | ru.yandex.market.partner.PartnerErrorHandlingAspect.handleErrors(PartnerErrorHandlingAspect.java:35) | sun.reflect.GeneratedMethodAccessor28.invoke(Unknown Source) | sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) | java.lang.reflect.Method.invoke(Method.java:497) | org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethodWithGivenArgs(AbstractAspectJAdvice.java:621) | org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethod(AbstractAspectJAdvice.java:610) | org.springframework.aop.aspectj.AspectJAroundAdvice.invoke(AspectJAroundAdvice.java:65) | org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) | org.springframework.aop.interceptor.ExposeInvocationInterceptor.invoke(ExposeInvocationInterceptor.java:91) | org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) | org.springframework.aop.framework.JdkDynamicAopProxy.invoke(JdkDynamicAopProxy.java:204) | com.sun.proxy.$Proxy65.process(Unknown Source) | ru.yandex.market.core.framework.context.InContextServantletDispatcher$ServantletWrapper.process(InContextServantletDispatcher.java:53) | ru.yandex.common.framework.core.ServantletManager.processRequest(ServantletManager.java:102) | ru.yandex.common.framework.core.ServantletManager.processCheckAccess(ServantletManager.java:127) | ru.yandex.common.framework.core.ServantletManager.processSingle(ServantletManager.java:176) | ru.yandex.common.framework.http.DefaultRequestHandler.handle(DefaultRequestHandler.java:130) | ru.yandex.market.partner.corba.servant.PartnerDefaultRequestHandler.handle(PartnerDefaultRequestHandler.java:44) | org.mortbay.jetty.handler.HandlerCollection.handle(HandlerCollection.java:114) | org.mortbay.jetty.handler.HandlerWrapper.handle(HandlerWrapper.java:152) | org.mortbay.jetty.Server.handle(Server.java:326) | org.mortbay.jetty.HttpConnection.handleRequest(HttpConnection.java:542) | org.mortbay.jetty.HttpConnection$RequestHandler.headerComplete(HttpConnection.java:928) | org.mortbay.jetty.HttpParser.parseNext(HttpParser.java:549) | org.mortbay.jetty.HttpParser.parseAvailable(HttpParser.java:212) | org.mortbay.jetty.HttpConnection.handle(HttpConnection.java:404) | org.mortbay.io.nio.SelectChannelEndPoint.run(SelectChannelEndPoint.java:410) | org.mortbay.thread.QueuedThreadPool$PoolThread.run(QueuedThreadPool.java:582) | </details><error-code>22DE8702E</error-code></system-error> ",
            "/sandbox/api-log.xml", "id=21165597&sort=date&order=desc&pageSize=50&sandbox=1&fdt=01.01.2015+00%3A00%3A00&tdt=28.02.2015+23%3A59%3A59&body=", "/page/content/data[actions=viewCpaApiLog]/errors/system-error", "317455807", ""
        );
    }

    @Test
    public void testParseSqlException() throws Exception {
      String lineSyslog = "[2017/04/14 13:39:06] warning: bugaga : critical 31.7.234.138 : <system-error><name>BadSqlGrammarException</name><message>PreparedStatementCallback; bad SQL grammar [select url from v_valid_domain where datasource_id = ?]; nested exception is java.sql.SQLSyntaxErrorException: ORA-00980: synonym translation is no longer valid </message><cause>org.springframework.jdbc.BadSqlGrammarException: PreparedStatementCallback; bad SQL grammar [select url from v_valid_domain where datasource_id = ?]; nested exception is java.sql.SQLSyntaxErrorException: ORA-00980: synonym translation is no longer valid </cause><details>org.springframework.jdbc.support.SQLExceptionSubclassTranslator.doTranslate(SQLExceptionSubclassTranslator.java:92) org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:72) org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:80) ru.yandex.market.core.util.spring.LoggingSQLErrorCodeSQLExceptionTranslator.translate(LoggingSQLErrorCodeSQLExceptionTranslator.java:26) org.springframework.jdbc.core.JdbcTemplate.execute(JdbcTemplate.java:605) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:639) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:668) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:676) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:716) org.springframework.jdbc.core.JdbcTemplate$$FastClassBySpringCGLIB$$a4771cb8.invoke(&lt;generated&gt;) org.springframework.cglib.proxy.MethodProxy.invoke(MethodProxy.java:204) org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.invokeJoinpoint(CglibAopProxy.java:701) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:150) ru.yandex.market.mbi.profiler.hitratio.HitRatioAspectHelper.invoke(HitRatioAspectHelper.java:52) ru.yandex.market.mbi.profiler.hitratio.HitRatioAspectHelper.invoke(HitRatioAspectHelper.java:22) ru.yandex.market.mbi.profiler.ProfilerMethodInterceptor.invoke(ProfilerMethodInterceptor.java:20) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) ru.yandex.market.mbi.profiler.query.QueryProfilerAspectHelper.invoke(QueryProfilerAspectHelper.java:66) ru.yandex.market.mbi.profiler.query.QueryProfilerAspectHelper.invoke(QueryProfilerAspectHelper.java:48) ru.yandex.market.mbi.profiler.ProfilerMethodInterceptor.invoke(ProfilerMethodInterceptor.java:20) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) org.springframework.aop.framework.CglibAopProxy$DynamicAdvisedInterceptor.intercept(CglibAopProxy.java:633) org.springframework.jdbc.core.JdbcTemplate$$EnhancerBySpringCGLIB$$cc50f2da.query(&lt;generated&gt;) ru.yandex.market.core.feed.validation.impl.DbFeedValidationService.getValidDomains(DbFeedValidationService.java:125) ru.yandex.market.core.feed.validation.impl.DbFeedValidationService.checkURLDomain(DbFeedValidationService.java:301) ru.yandex.market.partner.feed.validation.ValidateFeedServantlet.validateUrl(ValidateFeedServantlet.java:142) ru.yandex.market.partner.feed.validation.ValidateFeedServantlet.extractRequest(ValidateFeedServantlet.java:119) ru.yandex.market.partner.feed.validation.ValidateFeedServantlet.processWithParams(ValidateFeedServantlet.java:83) ru.yandex.market.core.servantlet.AutoParamServantlet.process(AutoParamServantlet.java:36) sun.reflect.GeneratedMethodAccessor38.invoke(Unknown Source) sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) java.lang.reflect.Method.invoke(Method.java:498) org.springframework.aop.support.AopUtils.invokeJoinpointUsingReflection(AopUtils.java:317) org.springframework.aop.framework.ReflectiveMethodInvocation.invokeJoinpoint(ReflectiveMethodInvocation.java:183) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:150) org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint.proceed(MethodInvocationProceedingJoinPoint.java:80) ru.yandex.market.partner.PartnerErrorHandlingAspect.handleErrors(PartnerErrorHandlingAspect.java:36) sun.reflect.GeneratedMethodAccessor37.invoke(Unknown Source) sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) java.lang.reflect.Method.invoke(Method.java:498) org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethodWithGivenArgs(AbstractAspectJAdvice.java:621) org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethod(AbstractAspectJAdvice.java:610) org.springframework.aop.aspectj.AspectJAroundAdvice.invoke(AspectJAroundAdvice.java:65) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) org.springframework.aop.interceptor.ExposeInvocationInterceptor.invoke(ExposeInvocationInterceptor.java:91) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) org.springframework.aop.framework.JdkDynamicAopProxy.invoke(JdkDynamicAopProxy.java:204) com.sun.proxy.$Proxy85.process(Unknown Source) ru.yandex.common.framework.core.ServantletManager.processRequest(ServantletManager.java:111) ru.yandex.common.framework.core.ServantletManager.processCheckAccess(ServantletManager.java:136) ru.yandex.common.framework.core.ServantletManager.processSingle(ServantletManager.java:185) ru.yandex.common.framework.http.DefaultRequestHandler.handle(DefaultRequestHandler.java:135) ru.yandex.market.partner.corba.servant.PartnerDefaultRequestHandler.handle(PartnerDefaultRequestHandler.java:55) org.mortbay.jetty.handler.HandlerCollection.handle(HandlerCollection.java:114) org.mortbay.jetty.handler.HandlerWrapper.handle(HandlerWrapper.java:152) org.mortbay.jetty.Server.handle(Server.java:326) org.mortbay.jetty.HttpConnection.handleRequest(HttpConnection.java:542) org.mortbay.jetty.HttpConnection$RequestHandler.headerComplete(HttpConnection.java:928) org.mortbay.jetty.HttpParser.parseNext(HttpParser.java:549) org.mortbay.jetty.HttpParser.parseAvailable(HttpParser.java:212) org.mortbay.jetty.HttpConnection.handle(HttpConnection.java:404) org.mortbay.io.nio.SelectChannelEndPoint.run(SelectChannelEndPoint.java:410) org.mortbay.thread.QueuedThreadPool$PoolThread.run(QueuedThreadPool.java:582) </details><error-code>1ABFFANET</error-code></system-error> https://partner.market.yandex.ru/gate/feed/create-validation.xml : /page/content/create-validation/data[actions=validateFeed]/errors/system-error prev: parent:/page/content/create-validation/data[actions=validateFeed]/errors uid:";
      String lineFile = "[2017/04/14 13:39:06] warn: bugaga : critical 31.7.234.138 : <system-error><name>BadSqlGrammarException</name><message>PreparedStatementCallback; bad SQL grammar [select url from v_valid_domain where datasource_id = ?]; nested exception is java.sql.SQLSyntaxErrorException: ORA-00980: synonym translation is no longer valid </message><cause>org.springframework.jdbc.BadSqlGrammarException: PreparedStatementCallback; bad SQL grammar [select url from v_valid_domain where datasource_id = ?]; nested exception is java.sql.SQLSyntaxErrorException: ORA-00980: synonym translation is no longer valid </cause><details>org.springframework.jdbc.support.SQLExceptionSubclassTranslator.doTranslate(SQLExceptionSubclassTranslator.java:92) org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:72) org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:80) ru.yandex.market.core.util.spring.LoggingSQLErrorCodeSQLExceptionTranslator.translate(LoggingSQLErrorCodeSQLExceptionTranslator.java:26) org.springframework.jdbc.core.JdbcTemplate.execute(JdbcTemplate.java:605) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:639) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:668) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:676) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:716) org.springframework.jdbc.core.JdbcTemplate$$FastClassBySpringCGLIB$$a4771cb8.invoke(&lt;generated&gt;) org.springframework.cglib.proxy.MethodProxy.invoke(MethodProxy.java:204) org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.invokeJoinpoint(CglibAopProxy.java:701) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:150) ru.yandex.market.mbi.profiler.hitratio.HitRatioAspectHelper.invoke(HitRatioAspectHelper.java:52) ru.yandex.market.mbi.profiler.hitratio.HitRatioAspectHelper.invoke(HitRatioAspectHelper.java:22) ru.yandex.market.mbi.profiler.ProfilerMethodInterceptor.invoke(ProfilerMethodInterceptor.java:20) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) ru.yandex.market.mbi.profiler.query.QueryProfilerAspectHelper.invoke(QueryProfilerAspectHelper.java:66) ru.yandex.market.mbi.profiler.query.QueryProfilerAspectHelper.invoke(QueryProfilerAspectHelper.java:48) ru.yandex.market.mbi.profiler.ProfilerMethodInterceptor.invoke(ProfilerMethodInterceptor.java:20) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) org.springframework.aop.framework.CglibAopProxy$DynamicAdvisedInterceptor.intercept(CglibAopProxy.java:633) org.springframework.jdbc.core.JdbcTemplate$$EnhancerBySpringCGLIB$$cc50f2da.query(&lt;generated&gt;) ru.yandex.market.core.feed.validation.impl.DbFeedValidationService.getValidDomains(DbFeedValidationService.java:125) ru.yandex.market.core.feed.validation.impl.DbFeedValidationService.checkURLDomain(DbFeedValidationService.java:301) ru.yandex.market.partner.feed.validation.ValidateFeedServantlet.validateUrl(ValidateFeedServantlet.java:142) ru.yandex.market.partner.feed.validation.ValidateFeedServantlet.extractRequest(ValidateFeedServantlet.java:119) ru.yandex.market.partner.feed.validation.ValidateFeedServantlet.processWithParams(ValidateFeedServantlet.java:83) ru.yandex.market.core.servantlet.AutoParamServantlet.process(AutoParamServantlet.java:36) sun.reflect.GeneratedMethodAccessor38.invoke(Unknown Source) sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) java.lang.reflect.Method.invoke(Method.java:498) org.springframework.aop.support.AopUtils.invokeJoinpointUsingReflection(AopUtils.java:317) org.springframework.aop.framework.ReflectiveMethodInvocation.invokeJoinpoint(ReflectiveMethodInvocation.java:183) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:150) org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint.proceed(MethodInvocationProceedingJoinPoint.java:80) ru.yandex.market.partner.PartnerErrorHandlingAspect.handleErrors(PartnerErrorHandlingAspect.java:36) sun.reflect.GeneratedMethodAccessor37.invoke(Unknown Source) sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) java.lang.reflect.Method.invoke(Method.java:498) org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethodWithGivenArgs(AbstractAspectJAdvice.java:621) org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethod(AbstractAspectJAdvice.java:610) org.springframework.aop.aspectj.AspectJAroundAdvice.invoke(AspectJAroundAdvice.java:65) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) org.springframework.aop.interceptor.ExposeInvocationInterceptor.invoke(ExposeInvocationInterceptor.java:91) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) org.springframework.aop.framework.JdkDynamicAopProxy.invoke(JdkDynamicAopProxy.java:204) com.sun.proxy.$Proxy85.process(Unknown Source) ru.yandex.common.framework.core.ServantletManager.processRequest(ServantletManager.java:111) ru.yandex.common.framework.core.ServantletManager.processCheckAccess(ServantletManager.java:136) ru.yandex.common.framework.core.ServantletManager.processSingle(ServantletManager.java:185) ru.yandex.common.framework.http.DefaultRequestHandler.handle(DefaultRequestHandler.java:135) ru.yandex.market.partner.corba.servant.PartnerDefaultRequestHandler.handle(PartnerDefaultRequestHandler.java:55) org.mortbay.jetty.handler.HandlerCollection.handle(HandlerCollection.java:114) org.mortbay.jetty.handler.HandlerWrapper.handle(HandlerWrapper.java:152) org.mortbay.jetty.Server.handle(Server.java:326) org.mortbay.jetty.HttpConnection.handleRequest(HttpConnection.java:542) org.mortbay.jetty.HttpConnection$RequestHandler.headerComplete(HttpConnection.java:928) org.mortbay.jetty.HttpParser.parseNext(HttpParser.java:549) org.mortbay.jetty.HttpParser.parseAvailable(HttpParser.java:212) org.mortbay.jetty.HttpConnection.handle(HttpConnection.java:404) org.mortbay.io.nio.SelectChannelEndPoint.run(SelectChannelEndPoint.java:410) org.mortbay.thread.QueuedThreadPool$PoolThread.run(QueuedThreadPool.java:582) </details><error-code>1ABFFANET</error-code></system-error> https://partner.market.yandex.ru/gate/feed/create-validation.xml : /page/content/create-validation/data[actions=validateFeed]/errors/system-error prev: parent:/page/content/create-validation/data[actions=validateFeed]/errors uid:";

      checker.check(
        lineSyslog,
        new Date(1492166346000L),
        "hostname.test", "partner.market.yandex.ru", "critical", "31.7.234.138",
        "<system-error><name>BadSqlGrammarException</name><message>PreparedStatementCallback; bad SQL grammar [select url from v_valid_domain where datasource_id = ?]; nested exception is java.sql.SQLSyntaxErrorException: ORA-00980: synonym translation is no longer valid </message><cause>org.springframework.jdbc.BadSqlGrammarException: PreparedStatementCallback; bad SQL grammar [select url from v_valid_domain where datasource_id = ?]; nested exception is java.sql.SQLSyntaxErrorException: ORA-00980: synonym translation is no longer valid </cause><details>org.springframework.jdbc.support.SQLExceptionSubclassTranslator.doTranslate(SQLExceptionSubclassTranslator.java:92) org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:72) org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:80) ru.yandex.market.core.util.spring.LoggingSQLErrorCodeSQLExceptionTranslator.translate(LoggingSQLErrorCodeSQLExceptionTranslator.java:26) org.springframework.jdbc.core.JdbcTemplate.execute(JdbcTemplate.java:605) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:639) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:668) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:676) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:716) org.springframework.jdbc.core.JdbcTemplate$$FastClassBySpringCGLIB$$a4771cb8.invoke(&lt;generated&gt;) org.springframework.cglib.proxy.MethodProxy.invoke(MethodProxy.java:204) org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.invokeJoinpoint(CglibAopProxy.java:701) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:150) ru.yandex.market.mbi.profiler.hitratio.HitRatioAspectHelper.invoke(HitRatioAspectHelper.java:52) ru.yandex.market.mbi.profiler.hitratio.HitRatioAspectHelper.invoke(HitRatioAspectHelper.java:22) ru.yandex.market.mbi.profiler.ProfilerMethodInterceptor.invoke(ProfilerMethodInterceptor.java:20) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) ru.yandex.market.mbi.profiler.query.QueryProfilerAspectHelper.invoke(QueryProfilerAspectHelper.java:66) ru.yandex.market.mbi.profiler.query.QueryProfilerAspectHelper.invoke(QueryProfilerAspectHelper.java:48) ru.yandex.market.mbi.profiler.ProfilerMethodInterceptor.invoke(ProfilerMethodInterceptor.java:20) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) org.springframework.aop.framework.CglibAopProxy$DynamicAdvisedInterceptor.intercept(CglibAopProxy.java:633) org.springframework.jdbc.core.JdbcTemplate$$EnhancerBySpringCGLIB$$cc50f2da.query(&lt;generated&gt;) ru.yandex.market.core.feed.validation.impl.DbFeedValidationService.getValidDomains(DbFeedValidationService.java:125) ru.yandex.market.core.feed.validation.impl.DbFeedValidationService.checkURLDomain(DbFeedValidationService.java:301) ru.yandex.market.partner.feed.validation.ValidateFeedServantlet.validateUrl(ValidateFeedServantlet.java:142) ru.yandex.market.partner.feed.validation.ValidateFeedServantlet.extractRequest(ValidateFeedServantlet.java:119) ru.yandex.market.partner.feed.validation.ValidateFeedServantlet.processWithParams(ValidateFeedServantlet.java:83) ru.yandex.market.core.servantlet.AutoParamServantlet.process(AutoParamServantlet.java:36) sun.reflect.GeneratedMethodAccessor38.invoke(Unknown Source) sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) java.lang.reflect.Method.invoke(Method.java:498) org.springframework.aop.support.AopUtils.invokeJoinpointUsingReflection(AopUtils.java:317) org.springframework.aop.framework.ReflectiveMethodInvocation.invokeJoinpoint(ReflectiveMethodInvocation.java:183) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:150) org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint.proceed(MethodInvocationProceedingJoinPoint.java:80) ru.yandex.market.partner.PartnerErrorHandlingAspect.handleErrors(PartnerErrorHandlingAspect.java:36) sun.reflect.GeneratedMethodAccessor37.invoke(Unknown Source) sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) java.lang.reflect.Method.invoke(Method.java:498) org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethodWithGivenArgs(AbstractAspectJAdvice.java:621) org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethod(AbstractAspectJAdvice.java:610) org.springframework.aop.aspectj.AspectJAroundAdvice.invoke(AspectJAroundAdvice.java:65) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) org.springframework.aop.interceptor.ExposeInvocationInterceptor.invoke(ExposeInvocationInterceptor.java:91) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) org.springframework.aop.framework.JdkDynamicAopProxy.invoke(JdkDynamicAopProxy.java:204) com.sun.proxy.$Proxy85.process(Unknown Source) ru.yandex.common.framework.core.ServantletManager.processRequest(ServantletManager.java:111) ru.yandex.common.framework.core.ServantletManager.processCheckAccess(ServantletManager.java:136) ru.yandex.common.framework.core.ServantletManager.processSingle(ServantletManager.java:185) ru.yandex.common.framework.http.DefaultRequestHandler.handle(DefaultRequestHandler.java:135) ru.yandex.market.partner.corba.servant.PartnerDefaultRequestHandler.handle(PartnerDefaultRequestHandler.java:55) org.mortbay.jetty.handler.HandlerCollection.handle(HandlerCollection.java:114) org.mortbay.jetty.handler.HandlerWrapper.handle(HandlerWrapper.java:152) org.mortbay.jetty.Server.handle(Server.java:326) org.mortbay.jetty.HttpConnection.handleRequest(HttpConnection.java:542) org.mortbay.jetty.HttpConnection$RequestHandler.headerComplete(HttpConnection.java:928) org.mortbay.jetty.HttpParser.parseNext(HttpParser.java:549) org.mortbay.jetty.HttpParser.parseAvailable(HttpParser.java:212) org.mortbay.jetty.HttpConnection.handle(HttpConnection.java:404) org.mortbay.io.nio.SelectChannelEndPoint.run(SelectChannelEndPoint.java:410) org.mortbay.thread.QueuedThreadPool$PoolThread.run(QueuedThreadPool.java:582) </details><error-code>1ABFFANET</error-code></system-error> ",
        "/gate/feed/create-validation.xml", "", "/page/content/create-validation/data[actions=validateFeed]/errors/system-error", "", ""
      );
      checker.check(
        lineFile,
        new Date(1492166346000L),
        "hostname.test", "partner.market.yandex.ru", "critical", "31.7.234.138",
        "<system-error><name>BadSqlGrammarException</name><message>PreparedStatementCallback; bad SQL grammar [select url from v_valid_domain where datasource_id = ?]; nested exception is java.sql.SQLSyntaxErrorException: ORA-00980: synonym translation is no longer valid </message><cause>org.springframework.jdbc.BadSqlGrammarException: PreparedStatementCallback; bad SQL grammar [select url from v_valid_domain where datasource_id = ?]; nested exception is java.sql.SQLSyntaxErrorException: ORA-00980: synonym translation is no longer valid </cause><details>org.springframework.jdbc.support.SQLExceptionSubclassTranslator.doTranslate(SQLExceptionSubclassTranslator.java:92) org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:72) org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:80) ru.yandex.market.core.util.spring.LoggingSQLErrorCodeSQLExceptionTranslator.translate(LoggingSQLErrorCodeSQLExceptionTranslator.java:26) org.springframework.jdbc.core.JdbcTemplate.execute(JdbcTemplate.java:605) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:639) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:668) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:676) org.springframework.jdbc.core.JdbcTemplate.query(JdbcTemplate.java:716) org.springframework.jdbc.core.JdbcTemplate$$FastClassBySpringCGLIB$$a4771cb8.invoke(&lt;generated&gt;) org.springframework.cglib.proxy.MethodProxy.invoke(MethodProxy.java:204) org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.invokeJoinpoint(CglibAopProxy.java:701) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:150) ru.yandex.market.mbi.profiler.hitratio.HitRatioAspectHelper.invoke(HitRatioAspectHelper.java:52) ru.yandex.market.mbi.profiler.hitratio.HitRatioAspectHelper.invoke(HitRatioAspectHelper.java:22) ru.yandex.market.mbi.profiler.ProfilerMethodInterceptor.invoke(ProfilerMethodInterceptor.java:20) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) ru.yandex.market.mbi.profiler.query.QueryProfilerAspectHelper.invoke(QueryProfilerAspectHelper.java:66) ru.yandex.market.mbi.profiler.query.QueryProfilerAspectHelper.invoke(QueryProfilerAspectHelper.java:48) ru.yandex.market.mbi.profiler.ProfilerMethodInterceptor.invoke(ProfilerMethodInterceptor.java:20) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) org.springframework.aop.framework.CglibAopProxy$DynamicAdvisedInterceptor.intercept(CglibAopProxy.java:633) org.springframework.jdbc.core.JdbcTemplate$$EnhancerBySpringCGLIB$$cc50f2da.query(&lt;generated&gt;) ru.yandex.market.core.feed.validation.impl.DbFeedValidationService.getValidDomains(DbFeedValidationService.java:125) ru.yandex.market.core.feed.validation.impl.DbFeedValidationService.checkURLDomain(DbFeedValidationService.java:301) ru.yandex.market.partner.feed.validation.ValidateFeedServantlet.validateUrl(ValidateFeedServantlet.java:142) ru.yandex.market.partner.feed.validation.ValidateFeedServantlet.extractRequest(ValidateFeedServantlet.java:119) ru.yandex.market.partner.feed.validation.ValidateFeedServantlet.processWithParams(ValidateFeedServantlet.java:83) ru.yandex.market.core.servantlet.AutoParamServantlet.process(AutoParamServantlet.java:36) sun.reflect.GeneratedMethodAccessor38.invoke(Unknown Source) sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) java.lang.reflect.Method.invoke(Method.java:498) org.springframework.aop.support.AopUtils.invokeJoinpointUsingReflection(AopUtils.java:317) org.springframework.aop.framework.ReflectiveMethodInvocation.invokeJoinpoint(ReflectiveMethodInvocation.java:183) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:150) org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint.proceed(MethodInvocationProceedingJoinPoint.java:80) ru.yandex.market.partner.PartnerErrorHandlingAspect.handleErrors(PartnerErrorHandlingAspect.java:36) sun.reflect.GeneratedMethodAccessor37.invoke(Unknown Source) sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43) java.lang.reflect.Method.invoke(Method.java:498) org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethodWithGivenArgs(AbstractAspectJAdvice.java:621) org.springframework.aop.aspectj.AbstractAspectJAdvice.invokeAdviceMethod(AbstractAspectJAdvice.java:610) org.springframework.aop.aspectj.AspectJAroundAdvice.invoke(AspectJAroundAdvice.java:65) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) org.springframework.aop.interceptor.ExposeInvocationInterceptor.invoke(ExposeInvocationInterceptor.java:91) org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:172) org.springframework.aop.framework.JdkDynamicAopProxy.invoke(JdkDynamicAopProxy.java:204) com.sun.proxy.$Proxy85.process(Unknown Source) ru.yandex.common.framework.core.ServantletManager.processRequest(ServantletManager.java:111) ru.yandex.common.framework.core.ServantletManager.processCheckAccess(ServantletManager.java:136) ru.yandex.common.framework.core.ServantletManager.processSingle(ServantletManager.java:185) ru.yandex.common.framework.http.DefaultRequestHandler.handle(DefaultRequestHandler.java:135) ru.yandex.market.partner.corba.servant.PartnerDefaultRequestHandler.handle(PartnerDefaultRequestHandler.java:55) org.mortbay.jetty.handler.HandlerCollection.handle(HandlerCollection.java:114) org.mortbay.jetty.handler.HandlerWrapper.handle(HandlerWrapper.java:152) org.mortbay.jetty.Server.handle(Server.java:326) org.mortbay.jetty.HttpConnection.handleRequest(HttpConnection.java:542) org.mortbay.jetty.HttpConnection$RequestHandler.headerComplete(HttpConnection.java:928) org.mortbay.jetty.HttpParser.parseNext(HttpParser.java:549) org.mortbay.jetty.HttpParser.parseAvailable(HttpParser.java:212) org.mortbay.jetty.HttpConnection.handle(HttpConnection.java:404) org.mortbay.io.nio.SelectChannelEndPoint.run(SelectChannelEndPoint.java:410) org.mortbay.thread.QueuedThreadPool$PoolThread.run(QueuedThreadPool.java:582) </details><error-code>1ABFFANET</error-code></system-error> ",
        "/gate/feed/create-validation.xml", "", "/page/content/create-validation/data[actions=validateFeed]/errors/system-error", "", ""
      );
    }

    @Test
    public void testParseNoMatch() throws Exception {
        String lineSyslog = "[2015/09/24 06:44:56] err: URL using bad/illegal format or missing URL : block: http method: getHttp url: //m.market.yandex.ru/touch/gate.hid/user/grade-model.xml?modelid=11550749 owner: /usr/local/www5/market-mobile/touch/widgets/w-user-grade-model/w-user-grade-model.xml";
        String lineFile = "[2015/09/24 06:44:56] error: URL using bad/illegal format or missing URL : block: http method: getHttp url: //m.market.yandex.ru/touch/gate.hid/user/grade-model.xml?modelid=11550749 owner: /usr/local/www5/market-mobile/touch/widgets/w-user-grade-model/w-user-grade-model.xml";

        checker.checkEmpty(lineSyslog);
        checker.checkEmpty(lineFile);
    }

    @Test
    public void testParseRequestId() throws Exception {
        String lineSyslog = "[2017/07/18 16:02:39] warning: bugaga : log 5.255.235.82 : <xscript_invoke_failed error=\"server responded 403\" block=\"http\" method=\"getHttp\" id=\"mbi-payment:get-campaigns-finance-status\" url=\"http://mbi-partner.tst.vs.market.yandex.net:38271/getCampaignsFinanceStatus?id=10000623&amp;id=4000707&amp;id=10774&amp;id=5004069&amp;id=2005143&amp;id=1005144&amp;id=1006773&amp;id=1036812&amp;id=1068651&amp;id=21010427&amp;id=21018958&amp;id=21036622&amp;id=21036624&amp;id=21076152&amp;id=21076163&amp;_user_id=328926698&amp;euid=328926698\" status=\"403\" content-type=\"text/xml\"></xscript_invoke_failed> https://partner.market.yandex.ru/?list=yes : /page/w.queue/w.task[zinger:wheel.without-params.root][9]/page/content/statuses/finance/xscript_invoke_failed[mbi-payment:get-campaigns-finance-status] prev: parent:/page/w.queue/w.task[zinger:wheel.without-params.root][9]/page/content/statuses/finance uid:328926698 request_id:1500382951809/d161988b826c47371c3fe442a982f2f7";
        String lineFile = "[2017/07/18 16:02:39] warn: bugaga : log 5.255.235.82 : <xscript_invoke_failed error=\"server responded 403\" block=\"http\" method=\"getHttp\" id=\"mbi-payment:get-campaigns-finance-status\" url=\"http://mbi-partner.tst.vs.market.yandex.net:38271/getCampaignsFinanceStatus?id=10000623&amp;id=4000707&amp;id=10774&amp;id=5004069&amp;id=2005143&amp;id=1005144&amp;id=1006773&amp;id=1036812&amp;id=1068651&amp;id=21010427&amp;id=21018958&amp;id=21036622&amp;id=21036624&amp;id=21076152&amp;id=21076163&amp;_user_id=328926698&amp;euid=328926698\" status=\"403\" content-type=\"text/xml\"></xscript_invoke_failed> https://partner.market.yandex.ru/?list=yes : /page/w.queue/w.task[zinger:wheel.without-params.root][9]/page/content/statuses/finance/xscript_invoke_failed[mbi-payment:get-campaigns-finance-status] prev: parent:/page/w.queue/w.task[zinger:wheel.without-params.root][9]/page/content/statuses/finance uid:328926698 request_id:1500382951809/d161988b826c47371c3fe442a982f2f7";

        checker.check(
                lineSyslog,
                new Date(1500382959000L),
                "hostname.test", "partner.market.yandex.ru", "log", "5.255.235.82",
                "<xscript_invoke_failed error=\"server responded 403\" block=\"http\" method=\"getHttp\" id=\"mbi-payment:get-campaigns-finance-status\" url=\"http://mbi-partner.tst.vs.market.yandex.net:38271/getCampaignsFinanceStatus?id=10000623&amp;id=4000707&amp;id=10774&amp;id=5004069&amp;id=2005143&amp;id=1005144&amp;id=1006773&amp;id=1036812&amp;id=1068651&amp;id=21010427&amp;id=21018958&amp;id=21036622&amp;id=21036624&amp;id=21076152&amp;id=21076163&amp;_user_id=328926698&amp;euid=328926698\" status=\"403\" content-type=\"text/xml\"></xscript_invoke_failed> ",
                "/", "list=yes", "/page/w.queue/w.task[zinger:wheel.without-params.root][9]/page/content/statuses/finance/xscript_invoke_failed[mbi-payment:get-campaigns-finance-status]",
                "328926698",
                "1500382951809/d161988b826c47371c3fe442a982f2f7"
        );
        checker.check(
                lineFile,
                new Date(1500382959000L),
                "hostname.test", "partner.market.yandex.ru", "log", "5.255.235.82",
                "<xscript_invoke_failed error=\"server responded 403\" block=\"http\" method=\"getHttp\" id=\"mbi-payment:get-campaigns-finance-status\" url=\"http://mbi-partner.tst.vs.market.yandex.net:38271/getCampaignsFinanceStatus?id=10000623&amp;id=4000707&amp;id=10774&amp;id=5004069&amp;id=2005143&amp;id=1005144&amp;id=1006773&amp;id=1036812&amp;id=1068651&amp;id=21010427&amp;id=21018958&amp;id=21036622&amp;id=21036624&amp;id=21076152&amp;id=21076163&amp;_user_id=328926698&amp;euid=328926698\" status=\"403\" content-type=\"text/xml\"></xscript_invoke_failed> ",
                "/", "list=yes", "/page/w.queue/w.task[zinger:wheel.without-params.root][9]/page/content/statuses/finance/xscript_invoke_failed[mbi-payment:get-campaigns-finance-status]",
                "328926698",
                "1500382951809/d161988b826c47371c3fe442a982f2f7"
        );
    }

}
