package ru.yandex.market.logshatter.parser.marketout;

import org.junit.Test;
import static org.junit.Assert.assertEquals;

import ru.yandex.market.logshatter.parser.LogParserChecker;

import java.util.Date;

public class ReportNginxLogParserTest {

    @Test
    public void testParse() throws Exception {
        LogParserChecker checker = new LogParserChecker(new ReportNginxLogParser());

        checker.checkEmpty(
            "tskv\ttskv_format=access-log-cs-vs-tools\ttimestamp=2017-05-04T06:39:06\ttimezone=+0300\tstatus=200\tprotocol=HTTP/1.1\tmethod=GET\trequest=/ping\treferer=-\tcookies=-\tuser_agent=-\tvhost=boombox.yandex.ru\tip=2a02:6b8:0:c01:1ce1:fd93:c0e5:a5f4\tx_forwarded_for=-\tx_real_ip=-\tbytes_sent=220\tpage_id=-\tpage_type=-\treq_id=1493869146691/b23a74718b6f59636bdfe6402c593e73\treq_id_seq=-\tupstream_resp_time=0.009\treq_time=0.010\tscheme=http\tdevice_type=-\tx_sub_req_id=-\tyandexuid=-\tssl_handshake_time=-\tmarket_buckets=-\tupstream_addr=[::1]:17051\tupstream_header_time=0.009\tupstream_status=200\tmarket_req_id=1493869146691/b23a74718b6f59636bdfe6402c593e73\tmsec=1493869146.701\ttvm=DISABLED\trequest_length=852\tenv=production\tlocation=sas\tsub_role=blue-shadow\tcluster=1\thost=2"
        );

        checker.check(
            "tskv\ttskv_format=access-log-cs-vs-tools\ttimestamp=2017-05-04T06:39:06\ttimezone=+0300\tstatus=200\tprotocol=HTTP/1.1\tmethod=GET\trequest=/yandsearch?base=market.yandex.ru&ip=83.220.85.97%2C83.220.85.97&ip-rids=54&yandexuid=619887601468401070&currency=RUR&reqid=b797213127f1acbce784b82b1a5add04&rearr-factors=&tz_offset=18000&numdoc=10&page=1&onstock=&hid=91657&rids=54&show-urls=geo&require-geo-coords=0&regset=2&new-delivery-mode=1&place=book_now_incut&hyperid=14020467&pp=251&pg=251&bsformat=2&showdiscounts=1&show_explicit_content=medicine&book-now-incut-page=1&referer=https%253A%252F%252Fmarket.yandex.ru%252Fproduct%252F14020467%252Foffers%253Fhid%253D91657%2526track%253Dtabs%2526deliveryincluded%253D0&subreqid=1&row_width=1&client=frontend&show-min-quantity=1\treferer=-\tcookies=yandex_gid=54; viewtype=list; yandexmarket=10,RUR,1,,,,2,0,0,0; spravka=dD0xNDgwNDgwNDcxO2k9OTQuMjQuMjUxLjE0Njt1PTE0ODA0ODA0NzE5ODcxNDAxMDg7aD03NGU3M2E4NDcwNjg0MWJhNTdhMzM4YWQ5NTBmNDFiNA==; yabs-frequency=/4/1G0209H3BLZR20TO/yoroS70dHqiVSd1m9qUp979mG2Sr3ovoS70dG000/; yandexuid=619887601468401070; yp=1502349731.altshow.2#1502607161.dswa.0#1502607161.dsws.10#1502607161.dwss.8#1500437363.nt.science#1502525500.st_set_s.2#1500693840.st_sethome_cl.1#1510469663.st_soft_stripe_s.3#1495224647.szm.1_00:1920x1080:1920x974#1784259705.udn.cDppdmEzNjgy#1486886108.ww.1#1785574996.yrts.1470214996#1502525288.dwbs.2#1502525322.st_home_s.1#1510469567.st_set_home_s.1#1482048627.ygu.1#1482636260.csc.2; mxp_desktop=-|0||; parent_reqid_seq=1b7edc3f90fee04452b528a3f7c3aa3f%2C6cde2f01d9974965088f23315ea9a8be%2C26cd4b76eab8213599931b555c58e435%2C1480402487639%252F804dcf26ee3d535feae4286eec9bdb28%2C88b08a5ffb1af41485a2348c4155cc8b; uid=CmtNm1g9BSNW/HBiAwk2Ag==; cpa=unchecked\tuser_agent=Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)\tvhost=warehouse.yandex.ru\tip=2a02:6b8:0:2521:875e:8282:53dd:2407\tx_forwarded_for=2a02:6b8:0:2521:9cba:9089:63b:9985\tx_real_ip=2a02:6b8:0:2521:9cba:9089:63b:9985\tbytes_sent=1724\tpage_id=-\tpage_type=-\treq_id=1493869145975/b797213127f1acbce784b82b1a5add04/18\treq_id_seq=-\tupstream_resp_time=0.007\treq_time=1.008\tscheme=http\tdevice_type=-\tx_sub_req_id=-\tyandexuid=-\tssl_handshake_time=-\tmarket_buckets=-\tupstream_addr=[::1]:17051\tupstream_header_time=0.006\tupstream_status=200\tmarket_req_id=1493869145975/b797213127f1acbce784b82b1a5add04/18\tmsec=1493869146.645\ttvm=DISABLED\trequest_length=852\tenv=production\tlocation=sas\tsub_role=blue-shadow\tcluster=1\thost=2",
            new Date(1493869146000L), checker.getHost(), 7, 1008, 6, "book_now_incut", 200, 852, 1724, "production", 1, "YANDEX", "DESKTOP"
        );

        checker.check(
            "tskv\ttskv_format=tskv-market-default\ttimestamp=2017-05-04T06:39:06\ttimezone=+0300\tstatus=200\tprotocol=HTTP/1.1\tmethod=POST\trequest=/\treferer=-\tcookies=yandex_gid=54; viewtype=list; yandexmarket=10,RUR,1,,,,2,0,0,0; spravka=dD0xNDgwNDgwNDcxO2k9OTQuMjQuMjUxLjE0Njt1PTE0ODA0ODA0NzE5ODcxNDAxMDg7aD03NGU3M2E4NDcwNjg0MWJhNTdhMzM4YWQ5NTBmNDFiNA==; yabs-frequency=/4/1G0209H3BLZR20TO/yoroS70dHqiVSd1m9qUp979mG2Sr3ovoS70dG000/; yandexuid=619887601468401070; yp=1502349731.altshow.2#1502607161.dswa.0#1502607161.dsws.10#1502607161.dwss.8#1500437363.nt.science#1502525500.st_set_s.2#1500693840.st_sethome_cl.1#1510469663.st_soft_stripe_s.3#1495224647.szm.1_00:1920x1080:1920x974#1784259705.udn.cDppdmEzNjgy#1486886108.ww.1#1785574996.yrts.1470214996#1502525288.dwbs.2#1502525322.st_home_s.1#1510469567.st_set_home_s.1#1482048627.ygu.1#1482636260.csc.2; mxp_desktop=-|0||; parent_reqid_seq=1b7edc3f90fee04452b528a3f7c3aa3f%2C6cde2f01d9974965088f23315ea9a8be%2C26cd4b76eab8213599931b555c58e435%2C1480402487639%252F804dcf26ee3d535feae4286eec9bdb28%2C88b08a5ffb1af41485a2348c4155cc8b; uid=CmtNm1g9BSNW/HBiAwk2Ag==; cpa=unchecked\tuser_agent=-\tvhost=warehouse.yandex.ru\tip=2a02:6b8:0:2521:875e:8282:53dd:2407\tx_forwarded_for=2a02:6b8:0:2521:9cba:9089:63b:9985\tx_real_ip=2a02:6b8:0:2521:9cba:9089:63b:9985\tbytes_sent=1724\tpage_id=-\tpage_type=-\treq_id=1493869145975/b797213127f1acbce784b82b1a5add04/18\treq_id_seq=-\tupstream_resp_time=0.007\treq_time=1.008\tscheme=http\tdevice_type=-\tx_sub_req_id=-\tyandexuid=-\tssl_handshake_time=-\tmarket_buckets=-\tupstream_addr=[::1]:17051\tupstream_header_time=0.006\tupstream_status=200\tmarket_req_id=1493869145975/b797213127f1acbce784b82b1a5add04/18\tmsec=1493869146.645\ttvm=DISABLED\trequest_length=852\tenv=production\tlocation=sas\tsub_role=blue-shadow\tcluster=1\thost=2",
            new Date(1493869146000L), checker.getHost(), 7, 1008, 6, "parallel", 200, 852, 1724, "production", 1, "NONE", "OTHER"
        );
    }

    @Test
    public void testClientType() throws Exception {
        LogParserChecker checker = new LogParserChecker(new ReportNginxLogParser());

        checker.check(
            "tskv\ttskv_format=access-log-cs-vs-tools\ttimestamp=2017-05-04T06:39:06\ttimezone=+0300\tstatus=200\tprotocol=HTTP/1.1\tmethod=GET\trequest=/yandsearch?base=m.market.yandex.ru&touch=1&ip=83.220.85.97%2C83.220.85.97&ip-rids=54&yandexuid=619887601468401070&currency=RUR&reqid=b797213127f1acbce784b82b1a5add04&rearr-factors=&tz_offset=18000&numdoc=10&page=1&onstock=&hid=91657&rids=54&show-urls=geo&require-geo-coords=0&regset=2&new-delivery-mode=1&place=book_now_incut&hyperid=14020467&pp=251&pg=251&bsformat=2&showdiscounts=1&show_explicit_content=medicine&book-now-incut-page=1&referer=https%253A%252F%252Fmarket.yandex.ru%252Fproduct%252F14020467%252Foffers%253Fhid%253D91657%2526track%253Dtabs%2526deliveryincluded%253D0&subreqid=1&row_width=1&client=frontend&show-min-quantity=1\treferer=-\tcookies=yandex_gid=54; viewtype=list; yandexmarket=10,RUR,1,,,,2,0,0,0; spravka=dD0xNDgwNDgwNDcxO2k9OTQuMjQuMjUxLjE0Njt1PTE0ODA0ODA0NzE5ODcxNDAxMDg7aD03NGU3M2E4NDcwNjg0MWJhNTdhMzM4YWQ5NTBmNDFiNA==; yabs-frequency=/4/1G0209H3BLZR20TO/yoroS70dHqiVSd1m9qUp979mG2Sr3ovoS70dG000/; yandexuid=619887601468401070; yp=1502349731.altshow.2#1502607161.dswa.0#1502607161.dsws.10#1502607161.dwss.8#1500437363.nt.science#1502525500.st_set_s.2#1500693840.st_sethome_cl.1#1510469663.st_soft_stripe_s.3#1495224647.szm.1_00:1920x1080:1920x974#1784259705.udn.cDppdmEzNjgy#1486886108.ww.1#1785574996.yrts.1470214996#1502525288.dwbs.2#1502525322.st_home_s.1#1510469567.st_set_home_s.1#1482048627.ygu.1#1482636260.csc.2; mxp_desktop=-|0||; parent_reqid_seq=1b7edc3f90fee04452b528a3f7c3aa3f%2C6cde2f01d9974965088f23315ea9a8be%2C26cd4b76eab8213599931b555c58e435%2C1480402487639%252F804dcf26ee3d535feae4286eec9bdb28%2C88b08a5ffb1af41485a2348c4155cc8b; uid=CmtNm1g9BSNW/HBiAwk2Ag==; cpa=unchecked\tuser_agent=Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)\tvhost=warehouse.yandex.ru\tip=2a02:6b8:0:2521:875e:8282:53dd:2407\tx_forwarded_for=2a02:6b8:0:2521:9cba:9089:63b:9985\tx_real_ip=2a02:6b8:0:2521:9cba:9089:63b:9985\tbytes_sent=1724\tpage_id=-\tpage_type=-\treq_id=1493869145975/b797213127f1acbce784b82b1a5add04/18\treq_id_seq=-\tupstream_resp_time=0.007\treq_time=1.008\tscheme=http\tdevice_type=-\tx_sub_req_id=-\tyandexuid=-\tssl_handshake_time=-\tmarket_buckets=-\tupstream_addr=[::1]:17051\tupstream_header_time=0.006\tupstream_status=200\tmarket_req_id=1493869145975/b797213127f1acbce784b82b1a5add04/18\tmsec=1493869146.645\ttvm=DISABLED\trequest_length=852\tenv=production\tlocation=sas\tsub_role=blue-shadow\tcluster=1\thost=2"
        );
        assertEquals("TOUCH", checker.getFields()[11]);

        checker.check(
            "tskv\ttskv_format=access-log-cs-vs-tools\ttimestamp=2017-05-04T06:39:06\ttimezone=+0300\tstatus=200\tprotocol=HTTP/1.1\tmethod=GET\trequest=/yandsearch?base=15092.market-exp.yandex.ru&ip=83.220.85.97%2C83.220.85.97&ip-rids=54&yandexuid=619887601468401070&currency=RUR&reqid=b797213127f1acbce784b82b1a5add04&rearr-factors=&tz_offset=18000&numdoc=10&page=1&onstock=&hid=91657&rids=54&show-urls=geo&require-geo-coords=0&regset=2&new-delivery-mode=1&place=book_now_incut&hyperid=14020467&pp=251&pg=251&bsformat=2&showdiscounts=1&show_explicit_content=medicine&book-now-incut-page=1&referer=https%253A%252F%252Fmarket.yandex.ru%252Fproduct%252F14020467%252Foffers%253Fhid%253D91657%2526track%253Dtabs%2526deliveryincluded%253D0&subreqid=1&row_width=1&show-min-quantity=1\treferer=-\tcookies=yandex_gid=54; viewtype=list; yandexmarket=10,RUR,1,,,,2,0,0,0; spravka=dD0xNDgwNDgwNDcxO2k9OTQuMjQuMjUxLjE0Njt1PTE0ODA0ODA0NzE5ODcxNDAxMDg7aD03NGU3M2E4NDcwNjg0MWJhNTdhMzM4YWQ5NTBmNDFiNA==; yabs-frequency=/4/1G0209H3BLZR20TO/yoroS70dHqiVSd1m9qUp979mG2Sr3ovoS70dG000/; yandexuid=619887601468401070; yp=1502349731.altshow.2#1502607161.dswa.0#1502607161.dsws.10#1502607161.dwss.8#1500437363.nt.science#1502525500.st_set_s.2#1500693840.st_sethome_cl.1#1510469663.st_soft_stripe_s.3#1495224647.szm.1_00:1920x1080:1920x974#1784259705.udn.cDppdmEzNjgy#1486886108.ww.1#1785574996.yrts.1470214996#1502525288.dwbs.2#1502525322.st_home_s.1#1510469567.st_set_home_s.1#1482048627.ygu.1#1482636260.csc.2; mxp_desktop=-|0||; parent_reqid_seq=1b7edc3f90fee04452b528a3f7c3aa3f%2C6cde2f01d9974965088f23315ea9a8be%2C26cd4b76eab8213599931b555c58e435%2C1480402487639%252F804dcf26ee3d535feae4286eec9bdb28%2C88b08a5ffb1af41485a2348c4155cc8b; uid=CmtNm1g9BSNW/HBiAwk2Ag==; cpa=unchecked\tuser_agent=Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)\tvhost=warehouse.yandex.ru\tip=2a02:6b8:0:2521:875e:8282:53dd:2407\tx_forwarded_for=2a02:6b8:0:2521:9cba:9089:63b:9985\tx_real_ip=2a02:6b8:0:2521:9cba:9089:63b:9985\tbytes_sent=1724\tpage_id=-\tpage_type=-\treq_id=1493869145975/b797213127f1acbce784b82b1a5add04/18\treq_id_seq=-\tupstream_resp_time=0.007\treq_time=1.008\tscheme=http\tdevice_type=-\tx_sub_req_id=-\tyandexuid=-\tssl_handshake_time=-\tmarket_buckets=-\tupstream_addr=[::1]:17051\tupstream_header_time=0.006\tupstream_status=200\tmarket_req_id=1493869145975/b797213127f1acbce784b82b1a5add04/18\tmsec=1493869146.645\ttvm=DISABLED\trequest_length=852\tenv=production\tlocation=sas\tsub_role=blue-shadow\tcluster=1\thost=2"
        );
        assertEquals("OTHER", checker.getFields()[11]);

        checker.check(
            "tskv\ttskv_format=access-log-cs-vs-tools\ttimestamp=2017-05-04T06:39:06\ttimezone=+0300\tstatus=200\tprotocol=HTTP/1.1\tmethod=GET\trequest=/yandsearch?base=m.market.yandex.ru&ip=83.220.85.97%2C83.220.85.97&ip-rids=54&yandexuid=619887601468401070&currency=RUR&reqid=b797213127f1acbce784b82b1a5add04&rearr-factors=&tz_offset=18000&numdoc=10&page=1&onstock=&hid=91657&rids=54&show-urls=geo&require-geo-coords=0&regset=2&new-delivery-mode=1&place=book_now_incut&hyperid=14020467&pp=251&pg=251&bsformat=2&showdiscounts=1&show_explicit_content=medicine&book-now-incut-page=1&referer=https%253A%252F%252Fmarket.yandex.ru%252Fproduct%252F14020467%252Foffers%253Fhid%253D91657%2526track%253Dtabs%2526deliveryincluded%253D0&subreqid=1&row_width=1&client=cataloger&show-min-quantity=1\treferer=-\tcookies=yandex_gid=54; viewtype=list; yandexmarket=10,RUR,1,,,,2,0,0,0; spravka=dD0xNDgwNDgwNDcxO2k9OTQuMjQuMjUxLjE0Njt1PTE0ODA0ODA0NzE5ODcxNDAxMDg7aD03NGU3M2E4NDcwNjg0MWJhNTdhMzM4YWQ5NTBmNDFiNA==; yabs-frequency=/4/1G0209H3BLZR20TO/yoroS70dHqiVSd1m9qUp979mG2Sr3ovoS70dG000/; yandexuid=619887601468401070; yp=1502349731.altshow.2#1502607161.dswa.0#1502607161.dsws.10#1502607161.dwss.8#1500437363.nt.science#1502525500.st_set_s.2#1500693840.st_sethome_cl.1#1510469663.st_soft_stripe_s.3#1495224647.szm.1_00:1920x1080:1920x974#1784259705.udn.cDppdmEzNjgy#1486886108.ww.1#1785574996.yrts.1470214996#1502525288.dwbs.2#1502525322.st_home_s.1#1510469567.st_set_home_s.1#1482048627.ygu.1#1482636260.csc.2; mxp_desktop=-|0||; parent_reqid_seq=1b7edc3f90fee04452b528a3f7c3aa3f%2C6cde2f01d9974965088f23315ea9a8be%2C26cd4b76eab8213599931b555c58e435%2C1480402487639%252F804dcf26ee3d535feae4286eec9bdb28%2C88b08a5ffb1af41485a2348c4155cc8b; uid=CmtNm1g9BSNW/HBiAwk2Ag==; cpa=unchecked\tuser_agent=Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)\tvhost=warehouse.yandex.ru\tip=2a02:6b8:0:2521:875e:8282:53dd:2407\tx_forwarded_for=2a02:6b8:0:2521:9cba:9089:63b:9985\tx_real_ip=2a02:6b8:0:2521:9cba:9089:63b:9985\tbytes_sent=1724\tpage_id=-\tpage_type=-\treq_id=1493869145975/b797213127f1acbce784b82b1a5add04/18\treq_id_seq=-\tupstream_resp_time=0.007\treq_time=1.008\tscheme=http\tdevice_type=-\tx_sub_req_id=-\tyandexuid=-\tssl_handshake_time=-\tmarket_buckets=-\tupstream_addr=[::1]:17051\tupstream_header_time=0.006\tupstream_status=200\tmarket_req_id=1493869145975/b797213127f1acbce784b82b1a5add04/18\tmsec=1493869146.645\ttvm=DISABLED\trequest_length=852\tenv=production\tlocation=sas\tsub_role=blue-shadow\tcluster=1\thost=2"
        );
        assertEquals("cataloger", checker.getFields()[11]);
    }
}
