import json
import urllib.request
import os

import tvmauth

DIRECT_ABC_SERVICES = [
    169,    # Директ
    705,    # BannerStorage
    1795,   # Canvas
    559,    # Горыныч
]
ABC_API_BASE_URL = 'https://abc-back.yandex-team.ru'
ABC_TVM_APP_ID = 2012190
DIRECT_TVM_APP_ID = 2000767
DIRECT_TVM_SECRET_PATH = os.environ.get('DIRECT_TVM_SECRET_PATH', '/etc/direct-tokens/tvm2_direct-scripts-test')
MDS_RESOURCE_TYPES = [
    60,     # Bucket (test)
    49,     # Bucket
    61,     # Storage (test)
    32,     # Storage
]
MDS_ABC_PROVIDER = 895


def main():
    tvm_secret = open(DIRECT_TVM_SECRET_PATH).read().rstrip()
    tvm_client = tvmauth.TvmClient(
        tvmauth.TvmApiClientSettings(
            self_tvm_id=DIRECT_TVM_APP_ID,
            self_secret=tvm_secret,
            dsts={'abc': ABC_TVM_APP_ID}
        )
    )
    services = DIRECT_ABC_SERVICES
    unexplored_parents = DIRECT_ABC_SERVICES
    while unexplored_parents:
        url = ABC_API_BASE_URL + '/api/v4/services/?fields={}&parent__in={}'.format(
            ','.join(['id', 'children_count', 'state']),
            ','.join([str(id) for id in unexplored_parents]),
        )
        results = []
        while url:
            ticket = tvm_client.get_service_ticket_for('abc')
            req = urllib.request.Request(
                url,
                headers={
                    'Accept': 'application/json',
                    'X-Ya-Service-Ticket': ticket,
                },
            )
            with urllib.request.urlopen(req) as f:
                resp = json.load(f)
                results += resp['results']
                url = resp['next']
        unexplored_parents = []
        for item in results:
            if item['state'] not in ['closed', 'deleted']:
                services.append(item['id'])
            if item['children_count'] > 0:
                unexplored_parents.append(item['id'])

    resources = []
    i = 0
    chunk_length = 10
    while i < len(services):
        services_chunk = services[i:i+chunk_length]
        url = ABC_API_BASE_URL + '/api/v4/resources/consumers/?fields={}&service__in={}&type__in={}&provider={}'.format(
            ','.join(['resource.name', 'resource.type.name.ru', 'resource.type.id', 'service.id', 'service.name', 'service.slug']),
            ','.join([str(id) for id in services_chunk]),
            ','.join([str(id) for id in MDS_RESOURCE_TYPES]),
            MDS_ABC_PROVIDER,
        )
        while url:
            ticket = tvm_client.get_service_ticket_for('abc')
            req = urllib.request.Request(
                url,
                headers={
                    'Accept': 'application/json',
                    'X-Ya-Service-Ticket': ticket,
                },
            )
            with urllib.request.urlopen(req) as f:
                resp = json.load(f)
                resources += resp['results']
                url = resp['next']
        i += chunk_length
    for item in resources:
        resource = item['resource']
        print('\t'.join([
            resource['name'],
            resource['type']['name']['ru'],
            item['service']['name']['ru'],
            str(item['service']['id']),
            item['service']['slug'],
        ]))


if __name__ == '__main__':
    main()
