# coding: utf-8
import logging
import requests

_logger = logging.getLogger(__name__)
_logger.addHandler(logging.NullHandler())

JUGGLER_PUSH_URL = "http://juggler-push.search.yandex.net/events"
JUGGLER_CLIENT_PUSH_URL = "http://localhost:31579/events"


def send_events(events, push_url=JUGGLER_CLIENT_PUSH_URL, timeout=(10, 10)):
    # localhost:31579 - дефолтная локальная прокся, стоит везде, удобно из нее брать события для локальной агрегации
    # без прокси можно пушить в http://juggler-push.search.yandex.net/events

    data = {"events": events, "source": "direct.juggler_send_events"}

    _logger.debug("sending %s to %s ...", data, push_url)
    reply = requests.post(push_url, json=data, timeout=timeout)
    reply.raise_for_status()  # если ответили не 200 - что-то совсем плохо, нет смысла продолжать
    res = reply.json()
    _logger.debug("received response from juggler: %s", res)

    event_res = res["events"]
    if len(event_res) < len(events):
        raise Exception({"event": events[len(event_res)], "error": "no response"})
    for i in range(len(events)):
        if event_res[i]["code"] != 200:
            raise Exception({"event": events[i], "error": event_res[i]["error"]})

    return reply.json()


def send_one(host, service, status, description=None, **kwargs):
    if description is None:
        description = status
    return send_events([{"host": host, "service": service, "status": status, "description": description}], **kwargs)


def send_ok(host, service, description=None, **kwargs):
    return send_one(host, service, "OK", description, **kwargs)


def send_warn(host, service, description=None, **kwargs):
    return send_one(host, service, "WARN", description, **kwargs)


def send_crit(host, service, description=None, **kwargs):
    return send_one(host, service, "CRIT", description, **kwargs)
