import logging
import requests

from ci.tasklet.common.proto import service_pb2 as ci
from direct.infra.newci.check_appduty.proto import schema_tasklet
from tasklet.services.yav.proto import yav_pb2 as yav

ABC_URL = 'https://abc-back.yandex-team.ru/api/v4/services/members/'
SERVICE = '5649'
DUTY_URL = 'https://abc.yandex-team.ru/services/direct-app-duty/duty2/30725'
ROLE_CODES = ['direct-main-production-duty', 'direct-production-duty']

logger = logging.getLogger(__name__)


class CheckAppDutyImpl(schema_tasklet.CheckAppDutyBase):

    def init_input_defaults(self):
        if not self.input.params.startrek_secret_name:
            self.input.params.startrek_secret_name = 'sec-01crgb2w2czemp9gazbqkzgdz6'
        if not self.input.params.startrek_secret_key:
            self.input.params.startrek_secret_key = 'startrek_ppc'
        if not self.input.params.app_name:
            raise RuntimeError('app_name is not specified')

    def run(self):
        self.init_input_defaults()
        # Получаем секрет для доступа к abc(подходит oauth от трекера)
        spec = yav.YavSecretSpec(uuid=self.input.params.startrek_secret_name, key=self.input.params.startrek_secret_key)
        token = self.ctx.yav.get_secret(spec).secret
        response = requests.get(ABC_URL, params={'service': SERVICE, 'role__code__in': ','.join(ROLE_CODES)}, headers={"Authorization": 'OAuth %s' % token})
        appduty = []
        for person in response.json()['results']:
            appduty.append(person['person']['login'])
        appduty = list(set(appduty))
        if self.input.context.job_triggered_by in appduty:
            progress = ci.TaskletProgress()
            progress.job_instance_id.CopyFrom(self.input.context.job_instance_id)  # Id текущей выполняющейся задачи
            progress.module = 'JUGGLER'
            progress.url = 'https://juggler.yandex-team.ru/check_details/?host=direct.prod_apps-health&service=%s&project=direct.prod&last=1DAY' % self.input.params.app_name
            progress.progress = 1  # 100%
            progress.status = ci.TaskletProgress.Status.SUCCESSFUL
            self.ctx.ci.UpdateProgress(progress)
            self.output.results.deployer = self.input.context.flow_triggered_by
        else:
            raise RuntimeError('Release must be deployed only via current prod duty ' + DUTY_URL)
