import click
import jinja2

from library.python import resource


class ResourceLoader(jinja2.BaseLoader):
    @staticmethod
    def get_source(environment, template):
        content = resource.find(template)
        if not content:
            raise jinja2.TemplateNotFound(template)
        return content.decode(), template, True

    @staticmethod
    def list_templates(self):
        return sorted(resource.iterkeys('/'))


@click.command()
@click.argument('template')
def main(template):
    loader = jinja2.FileSystemLoader('templates')
    env = jinja2.Environment(loader=loader, trim_blocks=True, lstrip_blocks=True)

    template = env.get_template(template)
    print(template.render())


if __name__ == "__main__":
    main()
