#!/bin/bash

set -e

ARCADIA_ROOT="${PWD}"
while [[ ! -e "${ARCADIA_ROOT}/.arcadia.root" ]]; do
    if [[ "${ARCADIA_ROOT}" == "/" ]]; then
        echo "$0: must be run from inside Arcadia checkout" >&2
        exit 1
    fi
    ARCADIA_ROOT="$(dirname "${ARCADIA_ROOT}")"
done

ya make

./direct-generate-flow direct-api5.j2 > "$ARCADIA_ROOT"/direct/api5/a.yaml
./direct-generate-flow direct-apps-binlogbroker-logbrokerwriter.j2 > "$ARCADIA_ROOT"/direct/apps/binlogbroker/logbrokerwriter/a.yaml
./direct-generate-flow direct-apps-event-sourcing-system-router.j2 > "$ARCADIA_ROOT"/direct/apps/event-sourcing-system/router/a.yaml
./direct-generate-flow direct-apps-user-action-log-writer.j2 > "$ARCADIA_ROOT"/direct/apps/user-action-log/writer/a.yaml
./direct-generate-flow direct-canvas.j2 > "$ARCADIA_ROOT"/direct/canvas/a.yaml
./direct-generate-flow direct-intapi.j2 > "$ARCADIA_ROOT"/direct/intapi/a.yaml
./direct-generate-flow direct-jobs.j2 > "$ARCADIA_ROOT"/direct/jobs/a.yaml
./direct-generate-flow direct-logviewer.j2 > "$ARCADIA_ROOT"/direct/logviewer/a.yaml
./direct-generate-flow direct-oneshot.j2 > "$ARCADIA_ROOT"/direct/oneshot/a.yaml
./direct-generate-flow direct-web.j2 > "$ARCADIA_ROOT"/direct/web/a.yaml

./direct-generate-flow direct-tasklet-check-appduty.j2 > "$ARCADIA_ROOT"/direct/infra/newci/check_appduty/a.yaml
./direct-generate-flow direct-tasklet-get-nanny-hosts.j2 > "$ARCADIA_ROOT"/direct/infra/newci/get_nanny_hosts/a.yaml
./direct-generate-flow direct-tasklet-pci-dss-configs-check.j2 > "$ARCADIA_ROOT"/direct/infra/newci/pci_dss_configs_check/a.yaml
./direct-generate-flow direct-tasklet-pci-dss-review-check.j2 > "$ARCADIA_ROOT"/direct/infra/newci/pci_dss_review_check/a.yaml
./direct-generate-flow direct-tasklet-release-accepts.j2 > "$ARCADIA_ROOT"/direct/infra/newci/release_accepts/a.yaml
./direct-generate-flow direct-tasklet-tracker.j2 > "$ARCADIA_ROOT"/direct/infra/newci/tracker/a.yaml

echo Done.
