import os
import subprocess

import yatest.common as ycommon


generate_flow = ycommon.binary_path('direct/infra/newci/generate-flow/direct-generate-flow')

template_dir = ycommon.source_path('direct/infra/newci/generate-flow/templates')

files = [
    ('direct-api5.j2', 'direct/api5/a.yaml'),
    ('direct-apps-binlogbroker-logbrokerwriter.j2', 'direct/apps/binlogbroker/logbrokerwriter/a.yaml'),
    ('direct-apps-event-sourcing-system-router.j2', 'direct/apps/event-sourcing-system/router/a.yaml'),
    ('direct-apps-user-action-log-writer.j2', 'direct/apps/user-action-log/writer/a.yaml'),
    ('direct-canvas.j2', 'direct/canvas/a.yaml'),
    ('direct-intapi.j2', 'direct/intapi/a.yaml'),
    ('direct-jobs.j2', 'direct/jobs/a.yaml'),
    ('direct-logviewer.j2', 'direct/logviewer/a.yaml'),
    ('direct-oneshot.j2', 'direct/oneshot/a.yaml'),
    ('direct-web.j2', 'direct/web/a.yaml'),
    ('direct-tasklet-check-appduty.j2', 'direct/infra/newci/check_appduty/a.yaml'),
    ('direct-tasklet-get-nanny-hosts.j2', 'direct/infra/newci/get_nanny_hosts/a.yaml'),
    ('direct-tasklet-pci-dss-configs-check.j2', 'direct/infra/newci/pci_dss_configs_check/a.yaml'),
    ('direct-tasklet-pci-dss-review-check.j2', 'direct/infra/newci/pci_dss_review_check/a.yaml'),
    ('direct-tasklet-release-accepts.j2', 'direct/infra/newci/release_accepts/a.yaml'),
    ('direct-tasklet-tracker.j2', 'direct/infra/newci/tracker/a.yaml'),
]


def test_a_yaml_updated():
    for template, target in files:
        p = subprocess.run(
            [generate_flow, template],
            cwd=os.path.dirname(template_dir),
            stdout=subprocess.PIPE,
        )
        assert 0 == p.returncode

        with open(ycommon.source_path(target), 'rb') as target:
            expected = target.read()

        assert expected == p.stdout, (
            'existing a.yaml differs from generated one, '
            'regenerate it with direct/infra/newci/generate-flow/generate.sh'
        )
