import logging

from ci.tasklet.common.proto import service_pb2 as ci
from direct.infra.newci.release_accepts.proto import schema_tasklet
from tasklet.services.yav.proto import yav_pb2 as yav
from startrek_client import Startrek

logger = logging.getLogger(__name__)


class ReleaseAcceptImpl(schema_tasklet.ReleaseAcceptBase):

    def init_input_defaults(self):
        if not self.input.params.startrek_secret_name:
            self.input.params.startrek_secret_name = 'sec-01crgb2w2czemp9gazbqkzgdz6'
        if not self.input.params.startrek_secret_key:
            self.input.params.startrek_secret_key = 'startrek_ppc'
        if not self.input.params.startrek_issue_key:
            raise RuntimeError('issue_key is not specified')

    def run(self):
        self.init_input_defaults()
        # Получаем секрет для доступа к стартреку
        spec = yav.YavSecretSpec(uuid=self.input.params.startrek_secret_name, key=self.input.params.startrek_secret_key)
        token_value = self.ctx.yav.get_secret(spec).secret
        client = Startrek(useragent='Direct CI', token=token_value)
        issue_key = self.input.params.startrek_issue_key
        tickets = list(client.issues.get_all(filter='key:' + issue_key))
        if tickets:
            ticket = tickets[0]
        status = ticket.status.key
        if status == "readyToDeploy":
            # Выводим результат кубика
            progress = ci.TaskletProgress()
            progress.job_instance_id.CopyFrom(self.input.context.job_instance_id)  # Id текущей выполняющейся задачи
            progress.id = "tracker"  # Идентификатор состояния
            progress.progress = 1  # 100%
            progress.module = "STARTREK"  # icon
            progress.url = "https://st.yandex-team.ru/{}".format(ticket.key)
            progress.status = ci.TaskletProgress.Status.SUCCESSFUL
            self.ctx.ci.UpdateProgress(progress)
            self.output.results.startrek_issue_key = ticket.key
        else:
            logger.info('Ticket {} in status {} now.'.format(issue_key, status))
            raise RuntimeError('Release is not accepted')
