#!/usr/bin/python

import os
import mimetypes
import jinja2
import flask
from direct.infra.observatorium.app.views import blueprints

try:
    from library.python import resource
    is_binary = True
except ImportError:
    is_binary = False


def templates_from_resources(path):
    return resource.find(os.path.join('templates', path)).decode('utf-8')


def static(filename):
    return flask.Response(resource.find(os.path.join('static', filename)), mimetype=mimetypes.guess_type(filename)[0])


app = flask.Flask(__name__, template_folder='templates', static_folder=None if is_binary else 'static')

for blueprint in blueprints:
    app.register_blueprint(blueprint)

if is_binary:
    app.jinja_env.loader = jinja2.FunctionLoader(templates_from_resources)
    app.add_url_rule('/static/<path:filename>', view_func=static)

if __name__ == "__main__":
    app.run(host='::', port=5123)
