# -*- coding: utf8 -*-

import sys
import json
import requests
from flask import render_template, request, Blueprint
from direct.infra.observatorium.lib.tools.settings import DIRECT_PPC_STARTREK_TOKEN

balancers_blueprint = Blueprint('balancers', __name__, url_prefix='/balancers')

USER_AGENT = 'Direct.Observatorium'
RACKTABLES_URL = 'https://ro.racktables.yandex-team.ru/export/abc-objects.php'
SERVICES_ABC_API_URL = "https://abc-back.yandex-team.ru/api/v3/services/?id__in="
MEMBERS_ABC_API_URL = "https://abc-back.yandex-team.ru/api/v3/services/members/?person__login="


services_id2name = {}


@balancers_blueprint.route('/index')
@balancers_blueprint.route('/index/<path:params>')
def index(params=''):
    global services_id2name

    form = {
        'type': request.args.get('type', ''),
        'service': request.args.get('service', ''),
        'user': request.args.get('user', '')
    }

    if not form['service'] and not form['user'] and not form['type']:
        return render_template(
            'balancers/balancers_index.html',
            form=form,
            error_message=u'Пустые параметры поиска, показать нечего'
        )

    error_message = ""

    try:
        balancers = json.loads(requests.get(RACKTABLES_URL).content)

        # почему-то иногда попадается не список, а словарь
        for balancer in balancers:
            if type(balancer['services']) is dict:
                balancer['services'] = balancer['services'].values()

        # если задан логин, то сразу фильтруем по его сервисам
        if form['user']:
            users_services = get_services_by_login(form['user'])
            balancers = filter(lambda x: any(service in users_services for service in x['services']), balancers)

        # сортируем сначала по сервисам, а потом по названию балансера
        balancers = sorted(balancers, key=lambda x: (x['services'][0], x['name']))

        # фильтруем по типу
        if form['type'] and form['type'] != '---':
            balancers = filter(lambda x: x['type'] == form['type'], balancers)

        # берем сервисы, которых нет в services_id2name
        unknown_services = {service for balancer in balancers for service in
                            balancer['services'] if service not in services_id2name}

        # загружаем для новых сервисов их названия
        load_service_names(unknown_services)

        # формируем строку с сервисами для вывода
        for balancer in balancers:
            balancer['services_str'] = ', '.join([
                "%s:%s" % (service_id, services_id2name[service_id] if service_id in services_id2name else '')
                for service_id in balancer['services']
            ])

        for balancer in balancers:
            balancer['services'] = [
                services_id2name[service_id].lower() if service_id in services_id2name else ''
                for service_id in balancer['services']
            ]

        # фильтруем по названию сервиса
        if form['service']:
            service_lower = form['service'].lower()
            balancers = filter(lambda x: service_lower in x['services'], balancers)

    except:
        balancers = []
        error_message = "Error  events: %s" % [str(i) for i in sys.exc_info()]

    return render_template(
        'balancers/balancers_index.html',
        form=form,
        error_message=error_message,
        balancers=balancers,
    )


def load_service_names(service_ids):
    global services_id2name

    if not service_ids:
        return

    headers = {"Authorization": "OAuth %s" % DIRECT_PPC_STARTREK_TOKEN}
    service_url = "%s%s" % (SERVICES_ABC_API_URL, ','.join(service_ids))

    while service_url:
        services = json.loads(requests.get(service_url, headers=headers).content)

        for service in services['results']:
            services_id2name[str(service['id'])] = service['name']['en']

        service_url = services['next']


def get_services_by_login(login):
    headers = {"Authorization": "OAuth %s" % DIRECT_PPC_STARTREK_TOKEN}
    url = "%s%s" % (MEMBERS_ABC_API_URL, login)

    result = set()

    while url:
        services = json.loads(requests.get(url, headers=headers).content)

        for service in services['results']:
            if 'service' in service and 'id' in service['service']:
                result.add(str(service['service']['id']))

        url = services['next']

    return result
