# -*- coding: utf-8 -*-

from flask import render_template, request, Blueprint
from startrek_client import Startrek
import json
from direct.infra.observatorium.lib.tools.settings import DIRECT_PPC_STARTREK_TOKEN

tag_cloud_blueprint = Blueprint('tag_cloud', __name__, url_prefix='/tracker/filters')

items_per_page = 500
max_items = 1000
items_per_page_show = 200


@tag_cloud_blueprint.route('/index')
def index():
    return u'Hello, World! Write "/filters/do" for start!'


@tag_cloud_blueprint.route('/')
@tag_cloud_blueprint.route('/<path:params>')
def do(params=''):
    client = Startrek(useragent=u'direct-tag-cloud',
                      token=DIRECT_PPC_STARTREK_TOKEN)
    ticket_names = []
    components = []
    tags = []
    queues = []
    types = []
    assignees = []
    statuses = []
    priorities = []
    try:
        query = request.args.get('query') or ''
        filters = request.args.get('filters') or ''

        try:
            issues = list([])
            page = 0
            if query != '':
                while len(issues) < max_items:
                    page += 1
                    new_issues = client.issues.find(query, per_page=items_per_page, page=page)
                    if isinstance(new_issues, list):
                        issues.extend(new_issues)
                        break
                    else:
                        issues.extend(new_issues._data)
        except Exception as e:
            issues = []
            print e

        for x in issues:
            try:
                new_el = {
                    "key": x.key,
                    "summary": x.summary,
                    "priorities": x.priority.name,
                    "components": [j.name for j in x.components],
                    "tags": x.tags,
                    "types": x.type.name,
                    "queues": x.queue.key,
                    "statuses": x.status.name,
                }
                if x.assignee:
                    new_el["assignees"] = x.assignee.login + u'@'
                else:
                    new_el["assignees"] = u'Не назначен'

                components.extend(new_el["components"])
                assignees.append(new_el["assignees"])
                tags.extend(new_el["tags"])
                queues.append(new_el["queues"])
                types.append(new_el["types"])
                statuses.append(new_el["statuses"])
                priorities.append(new_el["priorities"])
                ticket_names.append(new_el)
            except Exception, e:
                print e
    except Exception as e:
        print e

    components = count(components)
    tags = count(tags)
    queues = count(queues)
    types = count(types)
    statuses = count(statuses)
    assignees = count(assignees)
    priorities = count(priorities)

    return render_template('tag_cloud/tag_cloud.html',
                           tickets=json.dumps(ticket_names),
                           components=json.dumps(components),
                           tags=json.dumps(tags),
                           queues=json.dumps(queues),
                           types=json.dumps(types),
                           assignees=json.dumps(assignees),
                           statuses=json.dumps(statuses),
                           priorities=json.dumps(priorities),
                           query=query,
                           filters=filters,
                           )


def count(ls):
    if not ls:
        return []
    ls.sort()
    new_ls = [{"name": ls[0], "quantity": 0}]
    for elem in ls:
        if new_ls[-1]['name'] == elem:
            new_ls[-1]['quantity'] += 1
        else:
            new_ls.append({"name": elem, "quantity": 1})
    new_ls.sort(key=lambda x: x['quantity'], reverse=True)
    return new_ls
