PY2_PROGRAM(observatorium-uwsgi)

OWNER(palasonic)

PEERDIR(
    contrib/python/uwsgi
    contrib/python/requests
    contrib/python/Flask
    contrib/python/juggler_sdk
    contrib/python/dateutil
    contrib/python/graphviz
    contrib/python/kazoo
    library/python/startrek_python_client
    library/python/resource
    direct/infra/observatorium/lib
)

NO_CHECK_IMPORTS()

PY_MAIN(pyuwsgi:run)

PY_SRCS(
    run_app.py

    views/__init__.py
    views/balancers.py
    views/index.py
    views/juggler.py
    views/release_deps.py
    views/storages.py
    views/tag_cloud.py
    views/tracker_viewer.py
)

RESOURCE(
    data/hosts.json /data/hosts.json

    templates/base_main.html templates/base_main.html
    templates/index_main.html templates/index_main.html

    templates/balancers/balancers_index.html templates/balancers/balancers_index.html

    templates/juggler/complete_events.html templates/juggler/complete_events.html
    templates/juggler/downtimes.html templates/juggler/downtimes.html
    templates/juggler/index.html templates/juggler/index.html
    templates/juggler/checks.html templates/juggler/checks.html
    templates/juggler/base.html templates/juggler/base.html
    templates/juggler/raw_events.html templates/juggler/raw_events.html

    templates/release_deps/release_deps_ticket_viz.html templates/release_deps/release_deps_ticket_viz.html
    templates/release_deps/release_deps_list_tickets.html templates/release_deps/release_deps_list_tickets.html
    templates/release_deps/release_deps_index.html templates/release_deps/release_deps_index.html

    templates/storages/storages_index.html templates/storages/storages_index.html
    templates/storages/solomon_metadashboard.html templates/storages/solomon_metadashboard.html
    templates/storages/storages_replication_schema.html templates/storages/storages_replication_schema.html

    templates/tag_cloud/tag_cloud.html templates/tag_cloud/tag_cloud.html

    templates/tracker_viewer/graph_force.html templates/tracker_viewer/graph_force.html
    templates/tracker_viewer/graph_tree.html templates/tracker_viewer/graph_tree.html

    static/css/bootstrap.min.css static/css/bootstrap.min.css
    static/css/font-awesome.min.css static/css/font-awesome.min.css
    static/css/observatorium.css static/css/observatorium.css
    static/css/tag_cloud_style.css static/css/tag_cloud_style.css

    static/fonts/FontAwesome.otf static/fonts/FontAwesome.otf
    static/fonts/fontawesome-webfont.eot static/fonts/fontawesome-webfont.eot
    static/fonts/fontawesome-webfont.svg static/fonts/fontawesome-webfont.svg
    static/fonts/fontawesome-webfont.ttf static/fonts/fontawesome-webfont.ttf
    static/fonts/fontawesome-webfont.woff static/fonts/fontawesome-webfont.woff

    static/icons/cancel.svg static/icons/cancel.svg
    static/icons/guard.svg static/icons/guard.svg
    static/icons/obs.png static/icons/obs.png
    static/icons/plus.svg static/icons/plus.svg
    static/icons/tracker_viewer/issuetypes/111.svg static/icons/tracker_viewer/issuetypes/111.svg
    static/icons/tracker_viewer/issuetypes/113.svg static/icons/tracker_viewer/issuetypes/113.svg
    static/icons/tracker_viewer/issuetypes/11.svg static/icons/tracker_viewer/issuetypes/11.svg
    static/icons/tracker_viewer/issuetypes/12.svg static/icons/tracker_viewer/issuetypes/12.svg
    static/icons/tracker_viewer/issuetypes/1.svg static/icons/tracker_viewer/issuetypes/1.svg
    static/icons/tracker_viewer/issuetypes/2.svg static/icons/tracker_viewer/issuetypes/2.svg
    static/icons/tracker_viewer/issuetypes/3.svg static/icons/tracker_viewer/issuetypes/3.svg
    static/icons/tracker_viewer/issuetypes/404.svg static/icons/tracker_viewer/issuetypes/404.svg
    static/icons/tracker_viewer/issuetypes/49.svg static/icons/tracker_viewer/issuetypes/49.svg
    static/icons/tracker_viewer/issuetypes/4.svg static/icons/tracker_viewer/issuetypes/4.svg
    static/icons/tracker_viewer/issuetypes/53.svg static/icons/tracker_viewer/issuetypes/53.svg
    static/icons/tracker_viewer/issuetypes/63.svg static/icons/tracker_viewer/issuetypes/63.svg
    static/icons/tracker_viewer/issuetypes/71.svg static/icons/tracker_viewer/issuetypes/71.svg
    static/icons/tracker_viewer/issuetypes/7.svg static/icons/tracker_viewer/issuetypes/7.svg
    static/icons/tracker_viewer/issuetypes/d.svg static/icons/tracker_viewer/issuetypes/d.svg

    static/js/bootstrap.min.js static/js/bootstrap.min.js
    static/js/d3-3.5.12.min.js static/js/d3-3.5.12.min.js
    static/js/jquery-3.2.1.min.js static/js/jquery-3.2.1.min.js
    static/js/popper.min.js static/js/popper.min.js
    static/js/table2CSV.js static/js/table2CSV.js
)

END()
