#!/usr/bin/python
# -*- coding: utf8 -*-

import json
import requests
import re
import random
import time
import yaml

from startrek_client import Startrek

from direct.infra.observatorium.lib.tools.settings import DIRECT_PPC_STARTREK_TOKEN, JUGGLER_TOKEN
from direct.infra.observatorium.lib.tools.juggler import add_comment_to_ticket
from direct.infra.observatorium.lib.models.juggler import Downtimes

REMOVE_DOWNTIME_URL = 'http://juggler-api.search.yandex.net/v2/downtimes/remove_downtimes'
MAKE_DOWNTIME_URL = 'http://juggler-api.search.yandex.net/v2/downtimes/set_downtimes'
USER_AGENT = 'Direct.Observatorium'
DIRECT_NAMESPACE = 'direct.prod'

DIRECT_APPS_CONF = "/etc/yandex-direct/direct-apps.conf.yaml"
with open(DIRECT_APPS_CONF, 'r') as fd:
    APPS_CONF = yaml.load(fd, Loader=yaml.BaseLoader)['apps']

DIRECT_DEPLOYED_TAG = APPS_CONF['direct']['tracker-deployed-tag']


def need_extension(downtime, issue):
    if re.match(r'DIRECT-[0-9]+', issue.key, re.I):
        return (
            DIRECT_DEPLOYED_TAG not in issue.tags and
            time.time() - downtime.start_time < (int(downtime.days_to_rm) if downtime.days_to_rm else 30)*60*60*24
        )
    elif re.match(r'(?:DIRECTADMIN|DAHW)-[0-9]+', issue.key, re.I):
        return (
            not issue.status.key == u'closed' and
            time.time() - downtime.start_time < (int(downtime.days_to_rm) if downtime.days_to_rm else 30)*60*60*24
        )

    return True


def main():
    time.sleep(random.randint(1, 600))
    client = Startrek(useragent=u'direct-tag-cloud',
                      token=DIRECT_PPC_STARTREK_TOKEN)

    downtimes = Downtimes(namespace=[DIRECT_NAMESPACE]).get()

    headers = {"Content-Type": "application/json",
               "Accept": "application/json",
               "Authorization": 'OAuth %s' % JUGGLER_TOKEN}

    for downtime in downtimes:
        if (not downtime.end_time) or downtime.end_time < time.time() or (not downtime.ticket):
            continue

        try:
            issue = client.issues[downtime.ticket]
            remove_downtime_flag = False

            if need_extension(downtime, issue):
                if downtime.end_time - time.time() < 4*60*60:
                    req_data = {
                        "downtime_id": downtime.id,
                        "start_time": downtime.start_time,
                        "end_time": downtime.end_time + 60*60*24,  # продлеваем на 1 день
                        "description": downtime.full_description,
                        "filters": downtime.filters,
                    }

                    response = json.loads(
                        requests.post(MAKE_DOWNTIME_URL, data=json.dumps(req_data), headers=headers).content
                    )
                    response['success'] = 'downtime_id' in response
                else:
                    response = {'success': True}

            else:
                remove_downtime_flag = True
                req_data = {
                    "downtime_ids": [downtime.id],
                }

                response = json.loads(
                    requests.post(REMOVE_DOWNTIME_URL, data=json.dumps(req_data), headers=headers).content
                )
                response['success'] = 'downtimes' in response

            if not response['success']:
                print u'ERROR: %s %s: %s\n' % (response['message'], downtime.id, downtime.service_name)
            elif remove_downtime_flag:
                comment = u"Был удален даунтайм %s с фильтрами:\n%s" \
                          % (downtime.id, downtime.filters_str)

                add_comment_to_ticket(downtime.ticket, comment, u"remove_downtime (expired)")

        except Exception as e:
            print e


if __name__ == '__main__':
    main()
