#!/usr/bin/python
# -*- coding: utf8 -*-

from startrek_client import Startrek

from direct.infra.observatorium.lib.tools.settings import DIRECT_PPC_STARTREK_TOKEN
from direct.infra.observatorium.lib.tools.juggler import DOWNTIME_TICKET_COMPONENT
from direct.infra.observatorium.lib.models.juggler import Downtimes

import urllib3
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)


USER_AGENT = 'Direct.Observatorium'
DIRECT_NAMESPACE = 'direct.prod'
TICKET_TAG = 'active-downtime'


def main():
    startrek_client = Startrek(useragent=USER_AGENT, token=DIRECT_PPC_STARTREK_TOKEN)

    tickets_to_tag = set(
        downtime.ticket for downtime in Downtimes(namespace=[DIRECT_NAMESPACE]).get() if downtime.ticket
    )
    tickets_to_untag = [
        ticket.key
        for ticket in startrek_client.issues.find('Tags: %s Components: %s' % (TICKET_TAG, DOWNTIME_TICKET_COMPONENT))
        if ticket.key not in tickets_to_tag
    ]

    startrek_client.bulkchange.update(
        list(tickets_to_tag),
        tags={'add': [TICKET_TAG]}
    ).wait()

    startrek_client.bulkchange.update(
        tickets_to_untag,
        tags={'remove': [TICKET_TAG]}
    ).wait()


if __name__ == '__main__':
    main()
