#include <iostream>
#include <fstream>
#include <unordered_map>

using namespace std;

const int P = 1337;
long long get_hash(const string &line) {
    long long result = 0;
    for (const auto &c : line) {
        result += c;
        result *= P; 
    }
    return result;
}

int main(int argc, char** argv) {
    ios_base::sync_with_stdio(false);

    if (argc < 2) {
        cerr << "Usage: ./filter hashes_file < data.tsv\n";
        return 0;
    }

    unordered_map<long long, int> hash_count;
    
    string hash_file(argv[1]);
    {
        cerr << "Reading hashes\n";
        ifstream hash_stream(hash_file, ios::binary);

        long long hash;
        while (hash_stream.read(reinterpret_cast<char*>(&hash), sizeof(hash))) {
            hash_count[hash]++;
        }
    }

    cerr << "Reading data\n";
    
    string line;
    while (getline(cin, line)) {
        auto line_hash = get_hash(line);

        if (!hash_count.count(line_hash)) {
            cout << line << "\n";
        } else {
            int left = --hash_count[line_hash];
            if (left <= 0) {
                hash_count.erase(line_hash);
            }
        }
    }

    cout.flush();

    if (!hash_count.empty()) {
        int total_count = 0;
        for (const auto it : hash_count) {
            total_count += it.second;
        }

        cerr << "WARN: Leftover hashes: " << hash_count.size() << " unique, " << total_count << " non unique\n";
    }
}