#include <iostream>

using namespace std;

const int P = 1337;
long long get_hash(const string &line) {
    long long result = 0;
    for (const auto &c : line) {
        result += c;
        result *= P; 
    }
    return result;
}

int main(int argc, char** argv) {
    ios_base::sync_with_stdio(false);

    string line;
    while (getline(cin, line)) {
        auto line_hash = get_hash(line);
        cout.write(reinterpret_cast<const char*>(&line_hash), sizeof(line_hash));
    }
    cout.flush();
}