import sys
import os
import subprocess
import logging
from pathlib import Path

"""
Читает из файла дифф баз подобного формата:

2019-01-01	1	5631096				      |	2019-01-01	1	5513227
2019-01-01	2	5539537				      |	2019-01-01	2	5423868
2019-01-01	3	5594901				      |	2019-01-01	3	5478281
2019-01-01	4	5562438				      |	2019-01-01	4	5446784
2019-01-01	5	5322221				      |	2019-01-01	5	5211742
2019-01-01	6	5525646				      |	2019-01-01	6	5410712
2019-01-01	7	5265312				      |	2019-01-01	7	5156076
2019-01-01	8	5620629				      |	2019-01-01	8	5502930
2019-01-01	9	5420491				      |	2019-01-01	9	5307336
2019-01-01	10	5813300				      |	2019-01-01	10	5692142
2019-01-01	11	5681595				      |	2019-01-01	11	5563390
2019-01-01	12	5952670				      |	2019-01-01	12	5828992
2019-01-01	13	5748480				      |	2019-01-01	13	5628948

Забирает кусок из обоих баз, вычитает один из другого, если кол-во совпало с нужным вставляет в таблицу
"""

logFormatter = logging.Formatter("%(asctime)s [%(levelname)-5.5s] %(message)s")
rootLogger = logging.getLogger()
rootLogger.setLevel(logging.DEBUG)

fileHandler = logging.FileHandler("all.log")
fileHandler.setFormatter(logFormatter)
rootLogger.addHandler(fileHandler)

consoleHandler = logging.StreamHandler()
consoleHandler.setFormatter(logFormatter)
rootLogger.addHandler(consoleHandler)


data_dir = Path('data')
error_dir = Path('error')
for dir in [data_dir, error_dir]: 
    dir.mkdir(exist_ok=True)

if __name__ == "__main__":
    logging.info("Starting")

    if len(sys.argv) < 2:
        print('Usage: python3 all.py diff_file')
        exit(0)

    list_file = sys.argv[1]
    
    with open(list_file, 'r') as f:
        lines = f.readlines()

    logging.info("Read {} lines of tasks".format(len(lines)))

    for line in lines:
        date1, hour1, count1, _, date2, hour2, count2 = line.split()
        if date1 != date2 or hour1 != hour2:
            print('bad line: ' + line)
            exit(0)

        date = date1
        hour = hour1.rjust(2, "0")
        count_logs = int(count1)
        count_cloud = int(count2)
        target = count_logs - count_cloud

        logging.info("Running {}-{} with parts count ({}, {}) and target {}".format(date, hour, count_logs, count_cloud, target))

        try:
            logging.info("Calling ./run.sh {} {}".format(date, hour))
            subprocess.check_call("./run.sh {} {}".format(date, hour), shell=True)
            logging.info("Successfully finished")

            try:
                logging.info("Counting lines")
                count = subprocess.check_output(['wc', '-l', 'data/diff-{}-{}.tsv'.format(date, hour)])
                logging.info("Got count {}".format(count))

                count = count.split()[0]
                if count.isdigit():
                    count = int(count)
                    if count != target:
                        print('=========================== COUNT DIFFERS ==========================')
                        print('Got {} instead of {}'.format(count, target))
                        print('=========================== COUNT DIFFERS ==========================')
                    else:
                        insert_cmdline = "./insert.sh data/diff-{}-{}.tsv".format(date, hour)
                        logging.info("Running insert with " + insert_cmdline)
                        try:
                            subprocess.check_call(insert_cmdline, shell=True)
                            (data_dir / 'diff-{}-{}.tsv'.format(date, hour)).unlink()
                        except subprocess.CalledProcessError:
                            logging.info("Failed to insert!")
                            (error_dir / '{}-{}'.format(date, hour)).touch()

                else:
                    logging.error("Count is not digits", count)
                    
            except subprocess.CalledProcessError:
                logging.error('Something went counting lines')
                (error_dir / '{}-{}'.format(date, hour)).touch()

        except subprocess.CalledProcessError:
            logging.error('Error running diff')
            (error_dir / '{}-{}'.format(date, hour)).touch()
        