#!/bin/bash

set -e
set -o pipefail

date=$1
hour=$2
date_field=log_date
time_field=log_time

select="select * from trace where $date_field = '$date' and $time_field between '$date $hour:00:00' and '$date $hour:59:59' format TSV"

echo 'Reading and hashing'
password=`cat .read_password`
clickhouse-client --user=direct_reader --password=$password --host=ppchouse-cloud.direct.yandex.net --port=9440 --database=directdb --max_block_size=1024 -s -q "$select" \
    | ./hash > data/hashes-$date-$hour.bin

echo 'Filtering'
clickhouse-client --user=readonly --host=ppchouse.yandex.net --port=9000 --database=default --max_block_size=1024 -q "$select" \
    | ./filter data/hashes-$date-$hour.bin > data/diff-$date-$hour.tsv

echo 'Removing hashes'
rm data/hashes-$date-$hour.bin
