#!/usr/bin/env python

import os
import time
import yaml

MONFILE = "/local/cache/dt-multitail/status.db"
CONFIG = "/etc/yandex-dt-multitail/config.yaml"
MAXDURATION = 3600

def run():
        with open(CONFIG) as fd:
                config = yaml.load(fd)
        monfile = config.get('status_path', MONFILE)
        currentTime = int(time.time())
        if not os.path.exists(monfile):
                print "1; not found {0}".format(monfile)
                return
        fileStat = os.stat(monfile)
        if currentTime - fileStat.st_mtime > MAXDURATION:
                print "1; dt-multitail not working(current {0} modify {1} time)".format(currentTime, fileStat.st_mtime)
        else:
                print "0; dt-multitail working"
        return

if __name__ == '__main__':
        run()
